/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.typesafe.config.ConfigRenderOptions;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;

public class FlowSpecSerializer
implements JsonSerializer<FlowSpec> {
    public static final String FLOW_SPEC_URI_KEY = "uri";
    public static final String FLOW_SPEC_VERSION_KEY = "version";
    public static final String FLOW_SPEC_DESCRIPTION_KEY = "description";
    public static final String FLOW_SPEC_CONFIG_KEY = "config";
    public static final String FLOW_SPEC_CONFIG_AS_PROPERTIES_KEY = "configAsProperties";
    public static final String FLOW_SPEC_TEMPLATE_URIS_KEY = "templateURIs";
    public static final String FLOW_SPEC_CHILD_SPECS_KEY = "childSpecs";

    public JsonElement serialize(FlowSpec src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject flowSpecJson = new JsonObject();
        flowSpecJson.add(FLOW_SPEC_URI_KEY, context.serialize((Object)src.getUri()));
        flowSpecJson.add(FLOW_SPEC_VERSION_KEY, context.serialize((Object)src.getVersion()));
        flowSpecJson.add(FLOW_SPEC_DESCRIPTION_KEY, context.serialize((Object)src.getDescription()));
        flowSpecJson.add(FLOW_SPEC_CONFIG_KEY, context.serialize((Object)src.getConfig().root().render(ConfigRenderOptions.concise())));
        flowSpecJson.add(FLOW_SPEC_CONFIG_AS_PROPERTIES_KEY, context.serialize((Object)src.getConfigAsProperties()));
        JsonArray templateURIs = new JsonArray();
        if (src.getTemplateURIs().isPresent()) {
            for (URI templateURI : (Set)src.getTemplateURIs().get()) {
                templateURIs.add(context.serialize((Object)templateURI));
            }
        }
        flowSpecJson.add(FLOW_SPEC_TEMPLATE_URIS_KEY, (JsonElement)templateURIs);
        JsonArray childSpecs = new JsonArray();
        if (src.getChildSpecs().isPresent()) {
            for (Spec spec : (List)src.getChildSpecs().get()) {
                childSpecs.add(context.serialize((Object)spec));
            }
        }
        flowSpecJson.add(FLOW_SPEC_CHILD_SPECS_KEY, (JsonElement)childSpecs);
        return flowSpecJson;
    }
}

