/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.scheduler.AbstractJobSpecScheduler;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.util.service.StandardServiceConfig;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;

public class QuartzJobSpecScheduler
extends AbstractJobSpecScheduler {
    public static final Config DEFAULT_CFG = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"startUp.timeoutMs", (Object)1000).put((Object)"shutDown.timeoutMs", (Object)60000).build());
    protected static final String JOB_SPEC_KEY = "jobSpec";
    protected static final String JOB_RUNNABLE_KEY = "jobRunnable";
    @VisibleForTesting
    final SchedulerService _scheduler;
    private final StandardServiceConfig _cfg;

    public QuartzJobSpecScheduler(Optional<Logger> log, Config cfg, Optional<SchedulerService> scheduler) {
        super(log);
        this._scheduler = scheduler.isPresent() ? (SchedulerService)((Object)scheduler.get()) : QuartzJobSpecScheduler.createDefaultSchedulerService(cfg);
        this._cfg = new StandardServiceConfig(cfg.withFallback((ConfigMergeable)DEFAULT_CFG));
    }

    public QuartzJobSpecScheduler() {
        this((Optional<Logger>)Optional.absent(), ConfigFactory.empty(), (Optional<SchedulerService>)Optional.absent());
    }

    public QuartzJobSpecScheduler(Logger log) {
        this((Optional<Logger>)Optional.of((Object)log), ConfigFactory.empty(), (Optional<SchedulerService>)Optional.absent());
    }

    public QuartzJobSpecScheduler(Logger log, Config cfg) {
        this((Optional<Logger>)Optional.of((Object)log), cfg, (Optional<SchedulerService>)Optional.absent());
    }

    public QuartzJobSpecScheduler(GobblinInstanceEnvironment env) {
        this((Optional<Logger>)Optional.of((Object)env.getLog()), env.getSysConfig().getConfig(), (Optional<SchedulerService>)Optional.absent());
    }

    protected static SchedulerService createDefaultSchedulerService(Config cfg) {
        return new SchedulerService(cfg);
    }

    @Override
    protected JobSpecSchedule doScheduleJob(JobSpec jobSpec, Runnable jobRunnable) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(JOB_SPEC_KEY, (Object)jobSpec);
        jobDataMap.put(JOB_RUNNABLE_KEY, (Object)jobRunnable);
        JobDetail job = JobBuilder.newJob(QuartzJob.class).withIdentity(jobSpec.getUri().toString()).withDescription(Strings.nullToEmpty((String)jobSpec.getDescription())).usingJobData(jobDataMap).build();
        Trigger jobTrigger = this.createTrigger(job.getKey(), jobSpec);
        QuartzJobSchedule jobSchedule = new QuartzJobSchedule(jobSpec, jobRunnable, jobTrigger);
        try {
            this._scheduler.getScheduler().scheduleJob(job, jobTrigger);
            this.getLog().info(String.format("Scheduled job %s next two fire times: %s , %s.", jobSpec, jobTrigger.getNextFireTime(), jobTrigger.getFireTimeAfter(jobTrigger.getNextFireTime())));
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Scheduling failed for " + jobSpec + ":" + (Object)((Object)e), e);
        }
        return jobSchedule;
    }

    @Override
    protected void doUnschedule(JobSpecSchedule existingSchedule) {
        Preconditions.checkNotNull((Object)existingSchedule);
        Preconditions.checkArgument((boolean)(existingSchedule instanceof QuartzJobSchedule));
        QuartzJobSchedule quartzSchedule = (QuartzJobSchedule)existingSchedule;
        try {
            this._scheduler.getScheduler().deleteJob(quartzSchedule.getQuartzTrigger().getJobKey());
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unscheduling failed for " + existingSchedule.getJobSpec() + ":" + (Object)((Object)e), e);
        }
    }

    @Override
    protected void startUp() throws TimeoutException {
        super.startUp();
        this._scheduler.startAsync();
        this.getLog().info("Waiting QuartzJobSpecScheduler to run. Timeout is {} ms", (Object)this._cfg.getStartUpTimeoutMs());
        long startTime = System.currentTimeMillis();
        this._scheduler.awaitRunning(this._cfg.getStartUpTimeoutMs(), TimeUnit.MILLISECONDS);
        this.getLog().info("QuartzJobSpecScheduler runs. Time waited is {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    protected void shutDown() throws TimeoutException {
        super.shutDown();
        this._scheduler.stopAsync();
        this._scheduler.awaitTerminated(this._cfg.getShutDownTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    private Trigger createTrigger(JobKey jobKey, JobSpec jobSpec) {
        return TriggerBuilder.newTrigger().withIdentity("Cron for " + jobSpec.getUri()).forJob(jobKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobSpec.getConfig().getString("job.schedule"))).build();
    }

    @DisallowConcurrentExecution
    public static class QuartzJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            JobSpec jobSpec = (JobSpec)dataMap.get((Object)QuartzJobSpecScheduler.JOB_SPEC_KEY);
            Runnable jobRunnable = (Runnable)dataMap.get((Object)QuartzJobSpecScheduler.JOB_RUNNABLE_KEY);
            try {
                jobRunnable.run();
            }
            catch (Throwable t) {
                throw new JobExecutionException("Job runable for " + jobSpec + " failed.", t);
            }
        }
    }

    static class QuartzJobSchedule
    implements JobSpecSchedule {
        private final JobSpec jobSpec;
        private final Runnable jobRunnable;
        private final Trigger quartzTrigger;

        @Override
        public Optional<Long> getNextRunTimeMillis() {
            Date nextRuntime = this.quartzTrigger.getNextFireTime();
            return null != nextRuntime ? Optional.of((Object)nextRuntime.getTime()) : Optional.absent();
        }

        public QuartzJobSchedule(JobSpec jobSpec, Runnable jobRunnable, Trigger quartzTrigger) {
            this.jobSpec = jobSpec;
            this.jobRunnable = jobRunnable;
            this.quartzTrigger = quartzTrigger;
        }

        @Override
        public JobSpec getJobSpec() {
            return this.jobSpec;
        }

        @Override
        public Runnable getJobRunnable() {
            return this.jobRunnable;
        }

        public Trigger getQuartzTrigger() {
            return this.quartzTrigger;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuartzJobSchedule)) {
                return false;
            }
            QuartzJobSchedule other = (QuartzJobSchedule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JobSpec this$jobSpec = this.getJobSpec();
            JobSpec other$jobSpec = other.getJobSpec();
            if (this$jobSpec == null ? other$jobSpec != null : !((Object)this$jobSpec).equals(other$jobSpec)) {
                return false;
            }
            Runnable this$jobRunnable = this.getJobRunnable();
            Runnable other$jobRunnable = other.getJobRunnable();
            if (this$jobRunnable == null ? other$jobRunnable != null : !this$jobRunnable.equals(other$jobRunnable)) {
                return false;
            }
            Trigger this$quartzTrigger = this.getQuartzTrigger();
            Trigger other$quartzTrigger = other.getQuartzTrigger();
            return !(this$quartzTrigger == null ? other$quartzTrigger != null : !this$quartzTrigger.equals(other$quartzTrigger));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QuartzJobSchedule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobSpec $jobSpec = this.getJobSpec();
            result = result * 59 + ($jobSpec == null ? 43 : ((Object)$jobSpec).hashCode());
            Runnable $jobRunnable = this.getJobRunnable();
            result = result * 59 + ($jobRunnable == null ? 43 : $jobRunnable.hashCode());
            Trigger $quartzTrigger = this.getQuartzTrigger();
            result = result * 59 + ($quartzTrigger == null ? 43 : $quartzTrigger.hashCode());
            return result;
        }

        public String toString() {
            return "QuartzJobSpecScheduler.QuartzJobSchedule(jobSpec=" + this.getJobSpec() + ", jobRunnable=" + this.getJobRunnable() + ", quartzTrigger=" + this.getQuartzTrigger() + ")";
        }
    }
}

