/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.TimingEvent;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.metrics.GobblinJobMetricReporter;

public class ServiceGobblinJobMetricReporter
implements GobblinJobMetricReporter {
    static String FLOW_EDGE_ID_KEY = "flow.edge.id";
    private Optional<MetricContext> metricContext;

    public ServiceGobblinJobMetricReporter(Optional<MetricContext> metricContext) {
        this.metricContext = metricContext;
    }

    @Override
    public void reportWorkUnitCreationTimerMetrics(TimingEvent workUnitsCreationTimer, JobState jobState) {
        if (!this.metricContext.isPresent() || !jobState.getPropAsBoolean("gobblin.job.outputJobLevelMetrics", true)) {
            return;
        }
        String workunitCreationGaugeName = MetricRegistry.name((String)"GobblinService", (String[])new String[]{jobState.getProp("flow.group"), jobState.getProp("flow.name"), jobState.getProp(FLOW_EDGE_ID_KEY, jobState.getJobName()), "WorkUnitsCreationTimer"});
        long workUnitsCreationTime = workUnitsCreationTimer.getDuration() / TimeUnit.SECONDS.toMillis(1L);
        ContextAwareGauge workunitCreationGauge = ((MetricContext)this.metricContext.get()).newContextAwareGauge(workunitCreationGaugeName, () -> (int)workUnitsCreationTime);
        ((MetricContext)this.metricContext.get()).register(workunitCreationGaugeName, (Metric)workunitCreationGauge);
    }

    @Override
    public void reportWorkUnitCountMetrics(int workUnitCount, JobState jobState) {
        if (!this.metricContext.isPresent() || !jobState.getPropAsBoolean("gobblin.job.outputJobLevelMetrics", true)) {
            return;
        }
        String workunitCountGaugeName = MetricRegistry.name((String)"GobblinService", (String[])new String[]{jobState.getProp("flow.group"), jobState.getProp("flow.name"), jobState.getProp(FLOW_EDGE_ID_KEY, jobState.getJobName()), "WorkUnitsCreated"});
        ContextAwareGauge workunitCountGauge = ((MetricContext)this.metricContext.get()).newContextAwareGauge(workunitCountGaugeName, () -> workUnitCount);
        ((MetricContext)this.metricContext.get()).register(workunitCountGaugeName, (Metric)workunitCountGauge);
    }
}

