/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.TimingEvent;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.metrics.GobblinJobMetricReporter;

public class DefaultGobblinJobMetricReporter
implements GobblinJobMetricReporter {
    private Optional<MetricContext> metricContext;

    public DefaultGobblinJobMetricReporter(Optional<MetricContext> metricContext) {
        this.metricContext = metricContext;
    }

    @Override
    public void reportWorkUnitCreationTimerMetrics(TimingEvent workUnitsCreationTimer, JobState jobState) {
        if (!this.metricContext.isPresent()) {
            return;
        }
        String workunitCreationGaugeName = MetricRegistry.name((String)"JobMetrics", (String[])new String[]{"WorkUnitsCreationTimer", jobState.getJobName()});
        long workUnitsCreationTime = workUnitsCreationTimer.getDuration() / TimeUnit.SECONDS.toMillis(1L);
        ContextAwareGauge workunitCreationGauge = ((MetricContext)this.metricContext.get()).newContextAwareGauge(workunitCreationGaugeName, () -> (int)workUnitsCreationTime);
        ((MetricContext)this.metricContext.get()).register(workunitCreationGaugeName, (Metric)workunitCreationGauge);
    }

    @Override
    public void reportWorkUnitCountMetrics(int workUnitCount, JobState jobstate) {
    }
}

