/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.messaging.data;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import lombok.NonNull;
import org.apache.gobblin.runtime.messaging.data.DynamicWorkUnitDeserializationException;
import org.apache.gobblin.runtime.messaging.data.DynamicWorkUnitMessage;

public final class DynamicWorkUnitSerde {
    private static final Gson GSON = new Gson();
    private static final String PROPS_PREFIX = "DynamicWorkUnit.Props";
    private static final String MESSAGE_IMPLEMENTATION = "DynamicWorkUnit.Props.MessageImplementationClass";
    private static final Charset DEFAULT_CHAR_ENCODING = Charsets.UTF_8;

    private DynamicWorkUnitSerde() {
    }

    public static byte[] serialize(DynamicWorkUnitMessage msg) {
        Preconditions.checkNotNull((Object)msg, (Object)"Input message cannot be null");
        return DynamicWorkUnitSerde.toJsonObject(msg).toString().getBytes(DEFAULT_CHAR_ENCODING);
    }

    public static DynamicWorkUnitMessage deserialize(byte[] serializedMessage) {
        String json = new String(serializedMessage, DEFAULT_CHAR_ENCODING);
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return DynamicWorkUnitSerde.toDynamicWorkUnitMessage(jsonObject);
    }

    private static <T extends DynamicWorkUnitMessage> DynamicWorkUnitMessage toDynamicWorkUnitMessage(JsonObject json) {
        Preconditions.checkNotNull((Object)json, (Object)"Serialized msg cannot be null");
        try {
            if (!json.has(MESSAGE_IMPLEMENTATION)) {
                throw new DynamicWorkUnitDeserializationException(String.format("Unable to deserialize json to %s. Ensure that %s is used for serialization. %s does not have the key=%s used for deserializing to correct message implementation. json=%s", DynamicWorkUnitMessage.class.getSimpleName(), "DynamicWorkSerde#serialize(DynamicWorkUnitMessage msg)", json.getClass().getSimpleName(), MESSAGE_IMPLEMENTATION, json));
            }
            Class<?> clazz = Class.forName(json.get(MESSAGE_IMPLEMENTATION).getAsString());
            return (DynamicWorkUnitMessage)GSON.fromJson((JsonElement)json, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new DynamicWorkUnitDeserializationException(String.format("Input param %s contains invalid value for key=%s. This can be caused by the deserializer having different dependencies from the serializer. json=%s", json.getClass(), MESSAGE_IMPLEMENTATION, json), e);
        }
    }

    private static JsonObject toJsonObject(@NonNull DynamicWorkUnitMessage msg) {
        Preconditions.checkNotNull((Object)msg, (Object)"Input message cannot be null");
        JsonElement json = GSON.toJsonTree((Object)msg);
        JsonObject obj = json.getAsJsonObject();
        obj.addProperty(MESSAGE_IMPLEMENTATION, msg.getClass().getName());
        return obj;
    }
}

