/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.listeners;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.listeners.AbstractJobListener;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeJobListener
extends AbstractJobListener {
    private static final Logger log = LoggerFactory.getLogger(CompositeJobListener.class);
    private List<JobListener> listeners = Lists.newArrayList();

    public CompositeJobListener() {
    }

    public void addJobListener(JobListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onJobPrepare(JobContext jobContext) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (JobListener listener : this.listeners) {
            try {
                listener.onJobPrepare(jobContext);
            }
            catch (Exception e) {
                buf.append(listener.getClass().getName() + ":" + e.toString());
                log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        String exceptions = buf.toString();
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public void onJobStart(JobContext jobContext) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (JobListener listener : this.listeners) {
            try {
                listener.onJobStart(jobContext);
            }
            catch (Exception e) {
                buf.append(listener.getClass().getName() + ":" + e.toString());
                log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        String exceptions = buf.toString();
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public void onJobCompletion(JobContext jobContext) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (JobListener listener : this.listeners) {
            try {
                listener.onJobCompletion(jobContext);
            }
            catch (Exception e) {
                buf.append(listener.getClass().getName() + ":" + e.toString());
                log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        String exceptions = buf.toString();
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public void onJobCancellation(JobContext jobContext) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (JobListener listener : this.listeners) {
            try {
                listener.onJobCancellation(jobContext);
            }
            catch (Exception e) {
                buf.append(listener.getClass().getName() + ":" + e.toString());
                log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        String exceptions = buf.toString();
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public void onJobFailure(JobContext jobContext) throws Exception {
        StringBuffer buf = new StringBuffer();
        for (JobListener listener : this.listeners) {
            try {
                listener.onJobFailure(jobContext);
            }
            catch (Exception e) {
                buf.append(listener.getClass().getName() + ":" + e.toString());
                log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        String exceptions = buf.toString();
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(exceptions);
        }
    }

    public CompositeJobListener(List<JobListener> listeners) {
        this.listeners = listeners;
    }
}

