/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecStore;
import org.apache.gobblin.util.ConfigUtils;

public abstract class InstrumentedSpecStore
implements SpecStore {
    private OptionallyTimingInvoker getTimer;
    private OptionallyTimingInvoker existsTimer;
    private OptionallyTimingInvoker deleteTimer;
    private OptionallyTimingInvoker addTimer;
    private OptionallyTimingInvoker updateTimer;
    private OptionallyTimingInvoker getAllTimer;
    private OptionallyTimingInvoker getSizeTimer;
    private OptionallyTimingInvoker getURIsTimer;
    private OptionallyTimingInvoker getURIsWithTagTimer;
    private MetricContext metricContext;
    private final boolean instrumentationEnabled;

    public InstrumentedSpecStore(Config config, SpecSerDe specSerDe) {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)new State(ConfigUtils.configToProperties((Config)config)));
        this.metricContext = Instrumented.getMetricContext((State)new State(), this.getClass());
        this.getTimer = this.createTimingInvoker("-GET");
        this.existsTimer = this.createTimingInvoker("-EXISTS");
        this.deleteTimer = this.createTimingInvoker("-DELETE");
        this.addTimer = this.createTimingInvoker("-ADD");
        this.updateTimer = this.createTimingInvoker("-UPDATE");
        this.getAllTimer = this.createTimingInvoker("-GETALL");
        this.getSizeTimer = this.createTimingInvoker("-GETCOUNT");
        this.getURIsTimer = this.createTimingInvoker("-GETURIS");
        this.getURIsWithTagTimer = this.createTimingInvoker("-GETURISWITHTAG");
    }

    private OptionallyTimingInvoker createTimingInvoker(String suffix) {
        return new OptionallyTimingInvoker(this.createTimer(suffix));
    }

    private Optional<Timer> createTimer(String suffix) {
        return this.instrumentationEnabled ? Optional.of((Object)this.metricContext.timer(MetricRegistry.name((String)"GobblinService", (String[])new String[]{this.getClass().getSimpleName(), suffix}))) : Optional.absent();
    }

    @Override
    public boolean exists(URI specUri) throws IOException {
        return this.existsTimer.invokeMayThrowIO(() -> this.existsImpl(specUri));
    }

    @Override
    public void addSpec(Spec spec) throws IOException {
        this.addTimer.invokeMayThrowIO(() -> {
            this.addSpecImpl(spec);
            return null;
        });
    }

    @Override
    public boolean deleteSpec(URI specUri) throws IOException {
        return this.deleteTimer.invokeMayThrowIO(() -> this.deleteSpecImpl(specUri));
    }

    @Override
    public Spec getSpec(URI specUri) throws IOException, SpecNotFoundException {
        return this.getTimer.invokeMayThrowBoth(() -> this.getSpecImpl(specUri));
    }

    @Override
    public Collection<Spec> getSpecs(SpecSearchObject specSearchObject) throws IOException {
        return this.getTimer.invokeMayThrowIO(() -> this.getSpecsImpl(specSearchObject));
    }

    @Override
    public Spec updateSpec(Spec spec) throws IOException, SpecNotFoundException {
        return this.updateTimer.invokeMayThrowBoth(() -> this.updateSpecImpl(spec));
    }

    @Override
    public Spec updateSpec(Spec spec, long modifiedWatermark) throws IOException, SpecNotFoundException {
        return this.updateTimer.invokeMayThrowBoth(() -> this.updateSpecImpl(spec, modifiedWatermark));
    }

    @Override
    public Collection<Spec> getSpecs() throws IOException {
        return this.getAllTimer.invokeMayThrowIO(() -> this.getSpecsImpl());
    }

    @Override
    public Iterator<URI> getSpecURIs() throws IOException {
        return this.getURIsTimer.invokeMayThrowIO(() -> this.getSpecURIsImpl());
    }

    @Override
    public Iterator<URI> getSpecURIsWithTag(String tag) throws IOException {
        return this.getURIsWithTagTimer.invokeMayThrowIO(() -> this.getSpecURIsWithTagImpl(tag));
    }

    @Override
    public Collection<Spec> getSpecsPaginated(int startOffset, int batchSize) throws IOException, IllegalArgumentException {
        return this.getTimer.invokeMayThrowIO(() -> this.getSpecsPaginatedImpl(startOffset, batchSize));
    }

    @Override
    public int getSize() throws IOException {
        return this.getSizeTimer.invokeMayThrowIO(() -> this.getSizeImpl());
    }

    public Spec updateSpecImpl(Spec spec, long modifiedWatermark) throws IOException, SpecNotFoundException {
        return this.updateSpecImpl(spec);
    }

    public abstract void addSpecImpl(Spec var1) throws IOException;

    public abstract Spec updateSpecImpl(Spec var1) throws IOException, SpecNotFoundException;

    public abstract boolean existsImpl(URI var1) throws IOException;

    public abstract Spec getSpecImpl(URI var1) throws IOException, SpecNotFoundException;

    public abstract boolean deleteSpecImpl(URI var1) throws IOException;

    public abstract Collection<Spec> getSpecsImpl() throws IOException;

    public abstract Iterator<URI> getSpecURIsImpl() throws IOException;

    public abstract Iterator<URI> getSpecURIsWithTagImpl(String var1) throws IOException;

    public abstract int getSizeImpl() throws IOException;

    public abstract Collection<Spec> getSpecsPaginatedImpl(int var1, int var2) throws IOException, IllegalArgumentException;

    public Collection<Spec> getSpecsImpl(SpecSearchObject specUri) throws IOException {
        throw new UnsupportedOperationException();
    }

    static class OptionallyTimingInvoker {
        private final Optional<Timer> timer;

        public OptionallyTimingInvoker(Optional<Timer> timer) {
            this.timer = timer != null ? timer : Optional.absent();
        }

        public <T> T invokeMayThrowIO(SupplierMayThrowIO<T> f) throws IOException {
            try {
                return (T)this.invokeMayThrowBoth(() -> f.get());
            }
            catch (SpecNotFoundException e) {
                throw new RuntimeException("IMPOSSIBLE - prohibited by static checking!", e);
            }
        }

        public <T> T invokeMayThrowBoth(SupplierMayThrowBoth<T> f) throws IOException, SpecNotFoundException {
            if (this.timer.isPresent()) {
                long startTimeNanos = System.nanoTime();
                T result = f.get();
                ((Timer)this.timer.get()).update(System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
                return result;
            }
            return f.get();
        }

        @FunctionalInterface
        public static interface SupplierMayThrowBoth<T> {
            public T get() throws IOException, SpecNotFoundException;
        }

        @FunctionalInterface
        public static interface SupplierMayThrowIO<T> {
            public T get() throws IOException;
        }
    }
}

