/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import com.google.common.collect.Iterators;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.MultiContextIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterUtils;
import org.apache.gobblin.service.monitoring.JobStatus;
import org.apache.gobblin.service.monitoring.LatestFlowExecutionIdTracker;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobStatusRetriever
implements LatestFlowExecutionIdTracker {
    private static final Logger log = LoggerFactory.getLogger(JobStatusRetriever.class);
    public static final String EVENT_NAME_FIELD = "eventName";
    public static final String NA_KEY = "NA";
    protected final MetricContext metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)ConfigFactory.empty()), this.getClass());
    private final MultiContextIssueRepository issueRepository;

    protected JobStatusRetriever(MultiContextIssueRepository issueRepository) {
        this.issueRepository = Objects.requireNonNull(issueRepository);
    }

    public abstract Iterator<JobStatus> getJobStatusesForFlowExecution(String var1, String var2, long var3);

    public abstract Iterator<JobStatus> getJobStatusesForFlowExecution(String var1, String var2, long var3, String var5, String var6);

    @Override
    public long getLatestExecutionIdForFlow(String flowName, String flowGroup) {
        List<Long> lastKExecutionIds = this.getLatestExecutionIdsForFlow(flowName, flowGroup, 1);
        return lastKExecutionIds != null && !lastKExecutionIds.isEmpty() ? lastKExecutionIds.get(0) : -1L;
    }

    public Iterator<JobStatus> getLatestJobStatusByFlowNameAndGroup(String flowName, String flowGroup) {
        long latestExecutionId = this.getLatestExecutionIdForFlow(flowName, flowGroup);
        return latestExecutionId == -1L ? Iterators.emptyIterator() : this.getJobStatusesForFlowExecution(flowName, flowGroup, latestExecutionId);
    }

    protected JobStatus getJobStatus(State jobState) {
        List<Issue> issues;
        String flowGroup = jobState.getProp("flowGroup");
        String flowName = jobState.getProp("flowName");
        long flowExecutionId = Long.parseLong(jobState.getProp("flowExecutionId"));
        String jobName = jobState.getProp("jobName");
        String jobGroup = jobState.getProp("jobGroup");
        String jobTag = jobState.getProp("jobTag");
        long jobExecutionId = Long.parseLong(jobState.getProp("jobExecutionId", "0"));
        String eventName = jobState.getProp(EVENT_NAME_FIELD);
        long orchestratedTime = Long.parseLong(jobState.getProp("jobOrchestratedTime", "0"));
        long startTime = Long.parseLong(jobState.getProp("jobStartTime", "0"));
        long endTime = Long.parseLong(jobState.getProp("jobEndTime", "0"));
        String message = jobState.getProp("message", "");
        String lowWatermark = jobState.getProp("lowWatermark", "");
        String highWatermark = jobState.getProp("highWatermark", "");
        long processedCount = Long.parseLong(jobState.getProp("processedCount", "0"));
        int maxAttempts = Integer.parseInt(jobState.getProp("maxAttempts", "1"));
        int currentAttempts = Integer.parseInt(jobState.getProp("currentAttempts", "1"));
        boolean shouldRetry = Boolean.parseBoolean(jobState.getProp("shouldRetry", "false"));
        int progressPercentage = jobState.getPropAsInt("jobCompletionPercentage", 0);
        long lastProgressEventTime = jobState.getPropAsLong("jobLastProgressEventTime", 0L);
        try {
            String contextId = TroubleshooterUtils.getContextIdForJob(jobState.getProperties());
            issues = this.issueRepository.getAll(contextId);
        }
        catch (TroubleshooterException e) {
            log.warn("Cannot retrieve job issues", (Throwable)e);
            issues = Collections.emptyList();
        }
        return JobStatus.builder().flowName(flowName).flowGroup(flowGroup).flowExecutionId(flowExecutionId).jobName(jobName).jobGroup(jobGroup).jobTag(jobTag).jobExecutionId(jobExecutionId).eventName(eventName).lowWatermark(lowWatermark).highWatermark(highWatermark).orchestratedTime(orchestratedTime).startTime(startTime).endTime(endTime).message(message).processedCount(processedCount).maxAttempts(maxAttempts).currentAttempts(currentAttempts).shouldRetry(shouldRetry).progressPercentage(progressPercentage).lastProgressEventTime(lastProgressEventTime).issues(issues).build();
    }

    public abstract StateStore<State> getStateStore();

    public static boolean isFlowStatus(JobStatus jobStatus) {
        return jobStatus.getJobName() != null && jobStatus.getJobGroup() != null && jobStatus.getJobName().equals(NA_KEY) && jobStatus.getJobGroup().equals(NA_KEY);
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }
}

