/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import java.util.List;
import org.apache.gobblin.runtime.troubleshooter.Issue;

public class JobStatus {
    private final String jobName;
    private final String jobGroup;
    private final String jobTag;
    private final long jobExecutionId;
    private final long flowExecutionId;
    private final String flowName;
    private final String flowGroup;
    private final String eventName;
    private final long orchestratedTime;
    private final long startTime;
    private final long endTime;
    private String metrics;
    private final String message;
    private final long processedCount;
    private final String lowWatermark;
    private final String highWatermark;
    private final int maxAttempts;
    private final int currentAttempts;
    private final boolean shouldRetry;
    private final List<Issue> issues;
    private final int progressPercentage;
    private final long lastProgressEventTime;

    JobStatus(String jobName, String jobGroup, String jobTag, long jobExecutionId, long flowExecutionId, String flowName, String flowGroup, String eventName, long orchestratedTime, long startTime, long endTime, String metrics, String message, long processedCount, String lowWatermark, String highWatermark, int maxAttempts, int currentAttempts, boolean shouldRetry, List<Issue> issues, int progressPercentage, long lastProgressEventTime) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
        this.jobTag = jobTag;
        this.jobExecutionId = jobExecutionId;
        this.flowExecutionId = flowExecutionId;
        this.flowName = flowName;
        this.flowGroup = flowGroup;
        this.eventName = eventName;
        this.orchestratedTime = orchestratedTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.metrics = metrics;
        this.message = message;
        this.processedCount = processedCount;
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
        this.maxAttempts = maxAttempts;
        this.currentAttempts = currentAttempts;
        this.shouldRetry = shouldRetry;
        this.issues = issues;
        this.progressPercentage = progressPercentage;
        this.lastProgressEventTime = lastProgressEventTime;
    }

    public static JobStatusBuilder builder() {
        return new JobStatusBuilder();
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public String getJobTag() {
        return this.jobTag;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public long getFlowExecutionId() {
        return this.flowExecutionId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getFlowGroup() {
        return this.flowGroup;
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getOrchestratedTime() {
        return this.orchestratedTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getMetrics() {
        return this.metrics;
    }

    public String getMessage() {
        return this.message;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public String getLowWatermark() {
        return this.lowWatermark;
    }

    public String getHighWatermark() {
        return this.highWatermark;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getCurrentAttempts() {
        return this.currentAttempts;
    }

    public boolean isShouldRetry() {
        return this.shouldRetry;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public int getProgressPercentage() {
        return this.progressPercentage;
    }

    public long getLastProgressEventTime() {
        return this.lastProgressEventTime;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public static class JobStatusBuilder {
        private String jobName;
        private String jobGroup;
        private String jobTag;
        private long jobExecutionId;
        private long flowExecutionId;
        private String flowName;
        private String flowGroup;
        private String eventName;
        private long orchestratedTime;
        private long startTime;
        private long endTime;
        private String metrics;
        private String message;
        private long processedCount;
        private String lowWatermark;
        private String highWatermark;
        private int maxAttempts;
        private int currentAttempts;
        private boolean shouldRetry;
        private List<Issue> issues;
        private int progressPercentage;
        private long lastProgressEventTime;

        JobStatusBuilder() {
        }

        public JobStatusBuilder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public JobStatusBuilder jobGroup(String jobGroup) {
            this.jobGroup = jobGroup;
            return this;
        }

        public JobStatusBuilder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public JobStatusBuilder jobExecutionId(long jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
            return this;
        }

        public JobStatusBuilder flowExecutionId(long flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
            return this;
        }

        public JobStatusBuilder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public JobStatusBuilder flowGroup(String flowGroup) {
            this.flowGroup = flowGroup;
            return this;
        }

        public JobStatusBuilder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public JobStatusBuilder orchestratedTime(long orchestratedTime) {
            this.orchestratedTime = orchestratedTime;
            return this;
        }

        public JobStatusBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public JobStatusBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public JobStatusBuilder metrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public JobStatusBuilder message(String message) {
            this.message = message;
            return this;
        }

        public JobStatusBuilder processedCount(long processedCount) {
            this.processedCount = processedCount;
            return this;
        }

        public JobStatusBuilder lowWatermark(String lowWatermark) {
            this.lowWatermark = lowWatermark;
            return this;
        }

        public JobStatusBuilder highWatermark(String highWatermark) {
            this.highWatermark = highWatermark;
            return this;
        }

        public JobStatusBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public JobStatusBuilder currentAttempts(int currentAttempts) {
            this.currentAttempts = currentAttempts;
            return this;
        }

        public JobStatusBuilder shouldRetry(boolean shouldRetry) {
            this.shouldRetry = shouldRetry;
            return this;
        }

        public JobStatusBuilder issues(List<Issue> issues) {
            this.issues = issues;
            return this;
        }

        public JobStatusBuilder progressPercentage(int progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public JobStatusBuilder lastProgressEventTime(long lastProgressEventTime) {
            this.lastProgressEventTime = lastProgressEventTime;
            return this;
        }

        public JobStatus build() {
            return new JobStatus(this.jobName, this.jobGroup, this.jobTag, this.jobExecutionId, this.flowExecutionId, this.flowName, this.flowGroup, this.eventName, this.orchestratedTime, this.startTime, this.endTime, this.metrics, this.message, this.processedCount, this.lowWatermark, this.highWatermark, this.maxAttempts, this.currentAttempts, this.shouldRetry, this.issues, this.progressPercentage, this.lastProgressEventTime);
        }

        public String toString() {
            return "JobStatus.JobStatusBuilder(jobName=" + this.jobName + ", jobGroup=" + this.jobGroup + ", jobTag=" + this.jobTag + ", jobExecutionId=" + this.jobExecutionId + ", flowExecutionId=" + this.flowExecutionId + ", flowName=" + this.flowName + ", flowGroup=" + this.flowGroup + ", eventName=" + this.eventName + ", orchestratedTime=" + this.orchestratedTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", metrics=" + this.metrics + ", message=" + this.message + ", processedCount=" + this.processedCount + ", lowWatermark=" + this.lowWatermark + ", highWatermark=" + this.highWatermark + ", maxAttempts=" + this.maxAttempts + ", currentAttempts=" + this.currentAttempts + ", shouldRetry=" + this.shouldRetry + ", issues=" + this.issues + ", progressPercentage=" + this.progressPercentage + ", lastProgressEventTime=" + this.lastProgressEventTime + ")";
        }
    }
}

