/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.TaskMetrics;
import org.apache.gobblin.util.ClustersNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetrics
extends GobblinMetrics {
    private static final Logger log = LoggerFactory.getLogger(JobMetrics.class);
    public static final CreatorTag DEFAULT_CREATOR_TAG = new CreatorTag("driver");
    protected final String jobName;
    protected final CreatorTag creatorTag;

    protected JobMetrics(JobState job, CreatorTag tag) {
        this(job, null, tag);
    }

    protected JobMetrics(JobState job, MetricContext parentContext, CreatorTag creatorTag) {
        super(JobMetrics.name(job), parentContext, JobMetrics.tagsForJob(job));
        this.jobName = job.getJobName();
        this.creatorTag = creatorTag;
    }

    @Deprecated
    public static JobMetrics get(String jobName, String jobId) {
        return JobMetrics.get(new JobState(jobName, jobId), DEFAULT_CREATOR_TAG);
    }

    public static JobMetrics get(String jobName, String jobId, CreatorTag creatorTag) {
        return JobMetrics.get(new JobState(jobName, jobId), creatorTag);
    }

    public static JobMetrics get(String jobId, CreatorTag creatorTag) {
        return JobMetrics.get(null, jobId, creatorTag);
    }

    public static JobMetrics get(final JobState jobState, final MetricContext parentContext, final CreatorTag creatorTag) {
        return (JobMetrics)GOBBLIN_METRICS_REGISTRY.getOrCreate(JobMetrics.name(jobState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new JobMetrics(jobState, parentContext, creatorTag);
            }
        });
    }

    @Deprecated
    public static JobMetrics get(final JobState jobState) {
        return (JobMetrics)GOBBLIN_METRICS_REGISTRY.getOrCreate(JobMetrics.name(jobState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new JobMetrics(jobState, DEFAULT_CREATOR_TAG);
            }
        });
    }

    public static JobMetrics get(final JobState jobState, final CreatorTag creatorTag) {
        return (JobMetrics)GOBBLIN_METRICS_REGISTRY.getOrCreate(JobMetrics.name(jobState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new JobMetrics(jobState, creatorTag);
            }
        });
    }

    public static void remove(JobState jobState) {
        JobMetrics.remove((String)JobMetrics.name(jobState));
        for (TaskState taskState : jobState.getTaskStates()) {
            TaskMetrics.remove(taskState);
        }
    }

    public static void attemptRemove(String jobId, Tag matchTag) {
        JobMetrics jobMetrics;
        Optional gobblinMetricsOptional = GOBBLIN_METRICS_REGISTRY.get("gobblin.metrics." + jobId);
        JobMetrics jobMetrics2 = jobMetrics = gobblinMetricsOptional.isPresent() ? (JobMetrics)((Object)gobblinMetricsOptional.get()) : null;
        if (jobMetrics != null && jobMetrics.getCreatorTag().equals(matchTag)) {
            log.info("Removing job metrics because creator matches : " + matchTag.getValue());
            GOBBLIN_METRICS_REGISTRY.remove("gobblin.metrics." + jobId);
        }
    }

    private static String name(JobState jobState) {
        return "gobblin.metrics." + jobState.getJobId();
    }

    private static List<Tag<?>> tagsForJob(JobState jobState) {
        ArrayList tags = Lists.newArrayList();
        tags.add(new Tag("jobName", (Object)(jobState.getJobName() == null ? "" : jobState.getJobName())));
        tags.add(new Tag("jobId", (Object)jobState.getJobId()));
        tags.addAll(JobMetrics.getCustomTagsFromState((State)jobState));
        return tags;
    }

    @Deprecated
    public static String getClusterIdentifierTag() {
        return ClustersNames.getInstance().getClusterName();
    }

    public CreatorTag getCreatorTag() {
        return this.creatorTag;
    }

    public static class CreatorTag
    extends Tag<String> {
        public CreatorTag(String value) {
            super("creator", (Object)value);
        }
    }
}

