/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.gobblin.runtime.troubleshooter.InMemoryIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.MultiContextIssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;
import org.apache.gobblin.util.ConfigUtils;

@Singleton
public class InMemoryMultiContextIssueRepository
implements MultiContextIssueRepository {
    public static final int DEFAULT_MAX_CONTEXT_COUNT = 100;
    public static final String CONFIG_PREFIX = "gobblin.troubleshooter.inMemoryIssueRepository.";
    public static final String MAX_CONTEXT_COUNT = "gobblin.troubleshooter.inMemoryIssueRepository.maxContextCount";
    public static final String MAX_ISSUE_PER_CONTEXT = "gobblin.troubleshooter.inMemoryIssueRepository.maxIssuesPerContext";
    private final LRUMap<String, InMemoryIssueRepository> contextIssues;
    private final int maxIssuesPerContext;

    public InMemoryMultiContextIssueRepository() {
        this(ConfigFactory.empty());
    }

    @Inject
    public InMemoryMultiContextIssueRepository(Config config) {
        this(ConfigUtils.getInt((Config)config, (String)MAX_CONTEXT_COUNT, (Integer)100), ConfigUtils.getInt((Config)config, (String)MAX_ISSUE_PER_CONTEXT, (Integer)100));
    }

    public InMemoryMultiContextIssueRepository(int maxContextCount, int maxIssuesPerContext) {
        this.contextIssues = new LRUMap(maxContextCount);
        this.maxIssuesPerContext = maxIssuesPerContext;
    }

    @Override
    public synchronized List<Issue> getAll(String contextId) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.getOrDefault((Object)contextId, null);
        if (issueRepository != null) {
            return issueRepository.getAll();
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void put(String contextId, Issue issue) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.computeIfAbsent((Object)contextId, s -> new InMemoryIssueRepository(this.maxIssuesPerContext));
        issueRepository.put(issue);
    }

    @Override
    public synchronized void remove(String contextId, String issueCode) throws TroubleshooterException {
        InMemoryIssueRepository issueRepository = (InMemoryIssueRepository)this.contextIssues.getOrDefault((Object)contextId, null);
        if (issueRepository != null) {
            issueRepository.remove(issueCode);
        }
    }
}

