/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.spec_executorInstance.InMemorySpecExecutor;
import org.apache.gobblin.util.CompletedFuture;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MockedSpecExecutor
extends InMemorySpecExecutor {
    private SpecProducer<Spec> mockedSpecProducer = (SpecProducer)Mockito.mock(SpecProducer.class);

    public MockedSpecExecutor(Config config) {
        super(config);
        Mockito.when((Object)this.mockedSpecProducer.addSpec(Matchers.any())).thenReturn((Object)new CompletedFuture((Object)Boolean.TRUE, null));
        Mockito.when((Object)this.mockedSpecProducer.serializeAddSpecResponse((Future)Matchers.any())).thenReturn((Object)"");
        Mockito.when((Object)this.mockedSpecProducer.deserializeAddSpecResponse((String)Matchers.any())).thenReturn((Object)new CompletedFuture((Object)Boolean.TRUE, null));
    }

    public static SpecExecutor createDummySpecExecutor(URI uri) {
        Properties properties = new Properties();
        properties.setProperty("specExecInstance.uri", uri.toString());
        return new MockedSpecExecutor(ConfigFactory.parseProperties((Properties)properties));
    }

    @Override
    public Future<? extends SpecProducer<Spec>> getProducer() {
        return new CompletedFuture(this.mockedSpecProducer, null);
    }
}

