/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.local;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.runtime.AbstractTaskStateTracker;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.NewTaskCompletionEvent;
import org.apache.gobblin.runtime.Task;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTaskStateTracker
extends AbstractTaskStateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTaskStateTracker.class);
    private final JobState jobState;
    private final TaskExecutor taskExecutor;
    private final Map<String, ScheduledFuture<?>> scheduledReporters = Maps.newHashMap();
    private final EventBus eventBus;
    private final int maxTaskRetries;

    public LocalTaskStateTracker(Properties properties, JobState jobState, TaskExecutor taskExecutor, EventBus eventBus) {
        super(properties, LOG);
        this.jobState = jobState;
        this.taskExecutor = taskExecutor;
        this.eventBus = eventBus;
        this.maxTaskRetries = Integer.parseInt(properties.getProperty("task.maxretries", Integer.toString(5)));
    }

    @Override
    public void registerNewTask(Task task) {
        try {
            this.scheduledReporters.put(task.getTaskId(), this.scheduleTaskMetricsUpdater(new AbstractTaskStateTracker.TaskMetricsUpdater(this, task), task));
        }
        catch (RejectedExecutionException ree) {
            LOG.error(String.format("Scheduling of task state reporter for task %s was rejected", task.getTaskId()));
        }
    }

    @Override
    public void onTaskRunCompletion(Task task) {
        try {
            WorkUnitState.WorkingState state = task.getTaskState().getWorkingState();
            if (state == WorkUnitState.WorkingState.FAILED && task.getRetryCount() < this.maxTaskRetries) {
                this.taskExecutor.retry(task);
                return;
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to process a task completion callback", t);
        }
        task.markTaskCompletion();
    }

    @Override
    public void onTaskCommitCompletion(Task task) {
        try {
            if (GobblinMetrics.isEnabled((State)task.getTaskState().getWorkunit())) {
                task.updateRecordMetrics();
                task.updateByteMetrics();
            }
            if (this.scheduledReporters.containsKey(task.getTaskId())) {
                this.scheduledReporters.remove(task.getTaskId()).cancel(false);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to process a task completion callback", t);
        }
        this.jobState.addTaskState(task.getTaskState());
        this.eventBus.post((Object)new NewTaskCompletionEvent((Collection<TaskState>)ImmutableList.of((Object)task.getTaskState())));
        LOG.info(String.format("Task %s completed in %dms with state %s", task.getTaskId(), task.getTaskState().getTaskDuration(), task.getTaskState().getWorkingState()));
    }
}

