/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import java.io.IOException;
import java.util.Collection;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.publisher.HiveRegistrationPublisher;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskStateCollectorServiceHandler;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRegTaskStateCollectorServiceHandlerImpl
implements TaskStateCollectorServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(HiveRegTaskStateCollectorServiceHandlerImpl.class);
    private static final String TASK_COLLECTOR_SERVICE_PREFIX = "task.collector.service";
    private static final String HIVE_REG_PUBLISHER_CLASS = "hive.reg.publisher.class";
    private static final String HIVE_REG_PUBLISHER_CLASS_KEY = "task.collector.service.hive.reg.publisher.class";
    private static final String DEFAULT_HIVE_REG_PUBLISHER_CLASS = "org.apache.gobblin.publisher.HiveRegistrationPublisher";
    private HiveRegistrationPublisher hiveRegHandler;

    public HiveRegTaskStateCollectorServiceHandlerImpl(JobState jobState) {
        String className = jobState.getProp(HIVE_REG_PUBLISHER_CLASS_KEY, DEFAULT_HIVE_REG_PUBLISHER_CLASS);
        try {
            this.hiveRegHandler = (HiveRegistrationPublisher)GobblinConstructorUtils.invokeLongestConstructor(Class.forName(className), (Object[])new Object[]{jobState});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not instantiate HiveRegistrationPublisher " + className, e);
        }
    }

    @Override
    public void handle(Collection<? extends WorkUnitState> taskStates) throws IOException {
        this.hiveRegHandler.publishData(taskStates);
    }

    @Override
    public void close() throws IOException {
        this.hiveRegHandler.close();
    }
}

