/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BoundedBlockingRecordQueue<T> {
    private final int capacity;
    private final long timeout;
    private final TimeUnit timeoutTimeUnit;
    private final BlockingQueue<T> blockingQueue;
    private final Optional<QueueStats> queueStats;

    private BoundedBlockingRecordQueue(Builder<T> builder) {
        Preconditions.checkArgument((((Builder)builder).capacity > 0 ? 1 : 0) != 0, (Object)"Invalid queue capacity");
        Preconditions.checkArgument((((Builder)builder).timeout > 0L ? 1 : 0) != 0, (Object)"Invalid timeout time");
        this.capacity = ((Builder)builder).capacity;
        this.timeout = ((Builder)builder).timeout;
        this.timeoutTimeUnit = ((Builder)builder).timeoutTimeUnit;
        this.blockingQueue = Queues.newArrayBlockingQueue((int)((Builder)builder).capacity);
        this.queueStats = ((Builder)builder).ifCollectStats ? Optional.of((Object)new QueueStats()) : Optional.absent();
    }

    public boolean put(T record) throws InterruptedException {
        boolean offered = this.blockingQueue.offer(record, this.timeout, this.timeoutTimeUnit);
        if (this.queueStats.isPresent()) {
            ((QueueStats)this.queueStats.get()).putsRateMeter.mark();
        }
        return offered;
    }

    public T get() throws InterruptedException {
        T record = this.blockingQueue.poll(this.timeout, this.timeoutTimeUnit);
        if (this.queueStats.isPresent()) {
            ((QueueStats)this.queueStats.get()).getsRateMeter.mark();
        }
        return record;
    }

    public Optional<QueueStats> stats() {
        return this.queueStats;
    }

    public void clear() {
        this.blockingQueue.clear();
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public class QueueStats {
        public static final String QUEUE_SIZE = "queueSize";
        public static final String FILL_RATIO = "fillRatio";
        public static final String PUT_ATTEMPT_RATE = "putAttemptRate";
        public static final String GET_ATTEMPT_RATE = "getAttemptRate";
        public static final String PUT_ATTEMPT_COUNT = "putAttemptCount";
        public static final String GET_ATTEMPT_COUNT = "getAttemptCount";
        private final Gauge<Integer> queueSizeGauge;
        private final Gauge<Double> fillRatioGauge;
        private final Meter putsRateMeter;
        private final Meter getsRateMeter;

        public QueueStats() {
            this.queueSizeGauge = new Gauge<Integer>(){

                public Integer getValue() {
                    return BoundedBlockingRecordQueue.this.blockingQueue.size();
                }
            };
            this.fillRatioGauge = new Gauge<Double>(){

                public Double getValue() {
                    return (double)BoundedBlockingRecordQueue.this.blockingQueue.size() / (double)BoundedBlockingRecordQueue.this.capacity;
                }
            };
            this.putsRateMeter = new Meter();
            this.getsRateMeter = new Meter();
        }

        public int queueSize() {
            return (Integer)this.queueSizeGauge.getValue();
        }

        public double fillRatio() {
            return (Double)this.fillRatioGauge.getValue();
        }

        public double putAttemptRate() {
            return this.putsRateMeter.getMeanRate();
        }

        public long putAttemptCount() {
            return this.putsRateMeter.getCount();
        }

        public double getAttemptRate() {
            return this.getsRateMeter.getMeanRate();
        }

        public long getAttemptCount() {
            return this.getsRateMeter.getCount();
        }

        public void registerAll(MetricRegistry metricRegistry, String prefix) {
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{QUEUE_SIZE}), this.queueSizeGauge);
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{FILL_RATIO}), this.fillRatioGauge);
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{PUT_ATTEMPT_RATE}), (Metric)this.putsRateMeter);
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{GET_ATTEMPT_RATE}), (Metric)this.getsRateMeter);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(QUEUE_SIZE).append("=").append(this.queueSize()).append(", ");
            sb.append(FILL_RATIO).append("=").append(this.fillRatio()).append(", ");
            sb.append(PUT_ATTEMPT_RATE).append("=").append(this.putAttemptRate()).append(", ");
            sb.append(PUT_ATTEMPT_COUNT).append("=").append(this.putAttemptCount()).append(", ");
            sb.append(GET_ATTEMPT_RATE).append("=").append(this.getAttemptRate()).append(", ");
            sb.append(GET_ATTEMPT_COUNT).append("=").append(this.getAttemptCount()).append("]");
            return sb.toString();
        }
    }

    public static class Builder<T> {
        private int capacity = 100;
        private long timeout = 1000L;
        private TimeUnit timeoutTimeUnit = TimeUnit.MILLISECONDS;
        private boolean ifCollectStats = false;

        public Builder<T> hasCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder<T> useTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder<T> useTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
            this.timeoutTimeUnit = timeoutTimeUnit;
            return this;
        }

        public Builder<T> collectStats() {
            this.ifCollectStats = true;
            return this;
        }

        public BoundedBlockingRecordQueue<T> build() {
            return new BoundedBlockingRecordQueue(this);
        }
    }
}

