/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;

public class ReflectivePredicateEvaluator
implements Closeable {
    private static final String REFERENCE_INTERFACES = "refInterface";
    private static final String OPERATOR_ID = "operatorId";
    private static final Pattern FIELD_NAME_EXTRACTOR = Pattern.compile("(?:get([A-Z]))?(.+)");
    private static final String MODEL_PATTERN = "{version: 1, defaultSchema: 'MAIN',schemas: [{name: 'MAIN', type: 'custom', factory: '%s', operand: {%s: '%s', %s: '%d'}}]}";
    private static final String CONNECT_STRING_PATTERN = "jdbc:calcite:model=inline:%s";
    private static final Cache<Integer, ReflectivePredicateEvaluator> REGISTRY = CacheBuilder.newBuilder().weakValues().build();
    private static final AtomicInteger IDENTIFIER = new AtomicInteger();
    private final List<Class<?>> referenceInterfaces;
    private final int identifier;
    private final Connection conn;
    private final PreparedStatement stmnt;
    private final String sql;
    private volatile List<Object> objects;

    public ReflectivePredicateEvaluator(String sql, Class<?> ... referenceInterfaces) throws SQLException {
        this.referenceInterfaces = Lists.newArrayList((Object[])referenceInterfaces);
        this.sql = sql;
        this.identifier = IDENTIFIER.getAndIncrement();
        REGISTRY.put((Object)this.identifier, (Object)this);
        String model = this.computeModel();
        String connectString = String.format(CONNECT_STRING_PATTERN, model);
        this.conn = DriverManager.getConnection(connectString);
        this.stmnt = this.prepareStatement(sql);
    }

    private PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmnt = null;
        try {
            stmnt = this.conn.prepareStatement(sql);
            this.validateSql(stmnt, sql);
            return stmnt;
        }
        catch (Throwable t) {
            if (stmnt != null) {
                stmnt.close();
            }
            throw t;
        }
    }

    private String computeModel() {
        return String.format(MODEL_PATTERN, PESchemaFactory.class.getName(), REFERENCE_INTERFACES, Joiner.on((String)",").join((Iterable)this.referenceInterfaces.stream().map(Class::getName).collect(Collectors.toList())), OPERATOR_ID, this.identifier);
    }

    private void validateSql(PreparedStatement stmnt, String sql) throws SQLException {
        ResultSetMetaData metaData = stmnt.getMetaData();
        if (metaData.getColumnCount() != 1 || metaData.getColumnType(1) != 16) {
            throw new IllegalArgumentException("Statement is expected to return a single boolean column. Provided statement: " + sql);
        }
    }

    public boolean evaluate(Object ... objects) throws SQLException {
        return this.evaluate(Lists.newArrayList((Object[])objects), null);
    }

    public boolean evaluate(String sql, Object ... objects) throws SQLException {
        return this.evaluate(Lists.newArrayList((Object[])objects), sql);
    }

    public boolean evaluate(List<Object> objects) throws SQLException {
        return this.evaluate(objects, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(List<Object> objects, String sql) throws SQLException {
        ReflectivePredicateEvaluator reflectivePredicateEvaluator = this;
        synchronized (reflectivePredicateEvaluator) {
            boolean bl;
            block9: {
                String actualSql = sql == null ? this.sql : sql;
                PreparedStatement actualStmnt = null;
                try {
                    actualStmnt = sql == null ? this.stmnt : this.prepareStatement(sql);
                    this.objects = objects;
                    actualStmnt.execute();
                    ResultSet rs = actualStmnt.getResultSet();
                    if (!rs.next()) {
                        throw new IllegalArgumentException("Expected at least one returned row. SQL evaluated: " + actualSql);
                    }
                    boolean result = true;
                    do {
                        result &= rs.getBoolean(1);
                    } while (rs.next());
                    bl = result;
                    if (sql == null || actualStmnt == null) break block9;
                }
                catch (Throwable throwable) {
                    if (sql != null && actualStmnt != null) {
                        actualStmnt.close();
                    }
                    throw throwable;
                }
                actualStmnt.close();
            }
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.stmnt != null) {
                this.stmnt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException exc) {
            throw new IOException("Failed to close " + ReflectivePredicateEvaluator.class.getSimpleName(), exc);
        }
    }

    private static String computeFieldName(String methodName) {
        Matcher matcher = FIELD_NAME_EXTRACTOR.matcher(methodName);
        if (matcher.matches()) {
            return matcher.group(1) + matcher.group(2);
        }
        return null;
    }

    private static class MyDataType
    extends RelDataTypeImpl {
        private final String typeString;

        public MyDataType(List<? extends RelDataTypeField> fieldList, Class<?> refInterface) {
            super(fieldList);
            this.typeString = refInterface.getName();
            this.computeDigest();
        }

        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append(this.typeString);
        }
    }

    private static class PETable
    extends AbstractTable
    implements ProjectableFilterableTable {
        private final Class<?> referenceInterface;
        private final int operatorIdentifier;
        private volatile boolean initialized = false;
        private RelDataType rowType;
        private List<Function<Object, Object>> methodsForFields = new ArrayList<Function<Object, Object>>();

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, int[] projects) {
            List list = ((ReflectivePredicateEvaluator)REGISTRY.getIfPresent((Object)this.operatorIdentifier)).objects;
            int[] actualProjects = this.resolveProjects(projects);
            final Enumerator enumerator = Linq4j.enumerator((Collection)list.stream().filter(o -> this.referenceInterface.isAssignableFrom(o.getClass())).map(m -> {
                Object[] res = new Object[actualProjects.length];
                for (int i = 0; i < actualProjects.length; ++i) {
                    res[i] = this.methodsForFields.get(actualProjects[i]).apply(m);
                }
                return res;
            }).collect(Collectors.toList()));
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return enumerator;
                }
            };
        }

        private int[] resolveProjects(int[] projects) {
            if (projects == null) {
                projects = new int[this.methodsForFields.size()];
                for (int i = 0; i < projects.length; ++i) {
                    projects[i] = i;
                }
            }
            return projects;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            this.initialize((JavaTypeFactory)typeFactory);
            return this.rowType;
        }

        private synchronized void initialize(JavaTypeFactory typeFactory) {
            if (this.initialized) {
                return;
            }
            this.methodsForFields = new ArrayList<Function<Object, Object>>();
            ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
            for (Method method : this.referenceInterface.getMethods()) {
                String fieldName;
                if (method.getParameterCount() != 0 || (fieldName = ReflectivePredicateEvaluator.computeFieldName(method.getName())) == null) continue;
                this.methodsForFields.add(this.extractorForMethod(method));
                Class<Object> retType = method.getReturnType();
                if (retType.isEnum()) {
                    retType = String.class;
                }
                fields.add(new RelDataTypeFieldImpl(fieldName.toUpperCase(), fields.size(), typeFactory.createType(retType)));
            }
            this.rowType = new MyDataType(fields, this.referenceInterface);
            this.initialized = true;
        }

        private Function<Object, Object> extractorForMethod(Method method) {
            return o -> {
                try {
                    Object ret = method.invoke(o, new Object[0]);
                    return method.getReturnType().isEnum() ? ret.toString() : ret;
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException(roe);
                }
            };
        }

        @ConstructorProperties(value={"referenceInterface", "operatorIdentifier"})
        public PETable(Class<?> referenceInterface, int operatorIdentifier) {
            this.referenceInterface = referenceInterface;
            this.operatorIdentifier = operatorIdentifier;
        }

        public Class<?> getReferenceInterface() {
            return this.referenceInterface;
        }

        public int getOperatorIdentifier() {
            return this.operatorIdentifier;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public RelDataType getRowType() {
            return this.rowType;
        }

        public List<Function<Object, Object>> getMethodsForFields() {
            return this.methodsForFields;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public void setRowType(RelDataType rowType) {
            this.rowType = rowType;
        }

        public void setMethodsForFields(List<Function<Object, Object>> methodsForFields) {
            this.methodsForFields = methodsForFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PETable)) {
                return false;
            }
            PETable other = (PETable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Class<?> this$referenceInterface = this.getReferenceInterface();
            Class<?> other$referenceInterface = other.getReferenceInterface();
            if (this$referenceInterface == null ? other$referenceInterface != null : !this$referenceInterface.equals(other$referenceInterface)) {
                return false;
            }
            if (this.getOperatorIdentifier() != other.getOperatorIdentifier()) {
                return false;
            }
            if (this.isInitialized() != other.isInitialized()) {
                return false;
            }
            RelDataType this$rowType = this.getRowType();
            RelDataType other$rowType = other.getRowType();
            if (this$rowType == null ? other$rowType != null : !this$rowType.equals(other$rowType)) {
                return false;
            }
            List<Function<Object, Object>> this$methodsForFields = this.getMethodsForFields();
            List<Function<Object, Object>> other$methodsForFields = other.getMethodsForFields();
            return !(this$methodsForFields == null ? other$methodsForFields != null : !((Object)this$methodsForFields).equals(other$methodsForFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PETable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $referenceInterface = this.getReferenceInterface();
            result = result * 59 + ($referenceInterface == null ? 43 : $referenceInterface.hashCode());
            result = result * 59 + this.getOperatorIdentifier();
            result = result * 59 + (this.isInitialized() ? 79 : 97);
            RelDataType $rowType = this.getRowType();
            result = result * 59 + ($rowType == null ? 43 : $rowType.hashCode());
            List<Function<Object, Object>> $methodsForFields = this.getMethodsForFields();
            result = result * 59 + ($methodsForFields == null ? 43 : ((Object)$methodsForFields).hashCode());
            return result;
        }

        public String toString() {
            return "ReflectivePredicateEvaluator.PETable(referenceInterface=" + this.getReferenceInterface() + ", operatorIdentifier=" + this.getOperatorIdentifier() + ", initialized=" + this.isInitialized() + ", rowType=" + this.getRowType() + ", methodsForFields=" + this.getMethodsForFields() + ")";
        }
    }

    public static class PESchemaFactory
    implements SchemaFactory {
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            try {
                final ArrayList referenceInterfaces = new ArrayList();
                for (String iface : Splitter.on((String)",").splitToList((CharSequence)operand.get(ReflectivePredicateEvaluator.REFERENCE_INTERFACES).toString())) {
                    referenceInterfaces.add(Class.forName(iface));
                }
                final int operatorIdentifier = Integer.parseInt(operand.get(ReflectivePredicateEvaluator.OPERATOR_ID).toString());
                return new AbstractSchema(){

                    protected Map<String, Table> getTableMap() {
                        HashMap<String, Table> map = new HashMap<String, Table>();
                        for (Class iface : referenceInterfaces) {
                            map.put(iface.getSimpleName().toUpperCase(), (Table)new PETable(iface, operatorIdentifier));
                        }
                        return map;
                    }
                };
            }
            catch (ReflectiveOperationException roe) {
                throw new RuntimeException(roe);
            }
        }
    }
}

