/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.service.monitoring.FlowStatus;
import org.apache.gobblin.service.monitoring.JobStatus;
import org.apache.gobblin.service.monitoring.JobStatusRetriever;
import org.apache.gobblin.service.monitoring.KillFlowEvent;

@Alpha
public class FlowStatusGenerator {
    public static final List<String> FINISHED_STATUSES = Lists.newArrayList((Object[])new String[]{"FAILED", "COMPLETE", "CANCELLED"});
    public static final int MAX_LOOKBACK = 100;
    private final JobStatusRetriever jobStatusRetriever;
    private final EventBus eventBus;

    public List<FlowStatus> getLatestFlowStatus(String flowName, String flowGroup, int count, String tag) {
        List<Long> flowExecutionIds = this.jobStatusRetriever.getLatestExecutionIdsForFlow(flowName, flowGroup, count);
        if (flowExecutionIds == null || flowExecutionIds.isEmpty()) {
            return null;
        }
        List<FlowStatus> flowStatuses = flowExecutionIds.stream().map(flowExecutionId -> this.getFlowStatus(flowName, flowGroup, (long)flowExecutionId, tag)).collect(Collectors.toList());
        return flowStatuses;
    }

    public List<FlowStatus> getLatestFlowStatus(String flowName, String flowGroup, int count, String tag, String executionStatus) {
        if (executionStatus == null) {
            return this.getLatestFlowStatus(flowName, flowGroup, count, tag);
        }
        List<FlowStatus> flowStatuses = this.getLatestFlowStatus(flowName, flowGroup, 100, tag);
        if (flowStatuses == null) {
            return null;
        }
        ArrayList<FlowStatus> matchingFlowStatuses = new ArrayList<FlowStatus>();
        for (FlowStatus flowStatus : flowStatuses) {
            if (matchingFlowStatuses.size() == count) {
                return matchingFlowStatuses;
            }
            String executionStatusFromFlow = this.getExecutionStatus(flowStatus);
            if (!executionStatusFromFlow.equals(executionStatus)) continue;
            matchingFlowStatuses.add(this.getFlowStatus(flowName, flowGroup, flowStatus.getFlowExecutionId(), tag));
        }
        return matchingFlowStatuses;
    }

    private String getExecutionStatus(FlowStatus flowStatus) {
        List<Object> jobStatuses = Lists.newArrayList(flowStatus.getJobStatusIterator());
        return (jobStatuses = jobStatuses.stream().filter(JobStatusRetriever::isFlowStatus).collect(Collectors.toList())).isEmpty() ? "" : ((JobStatus)jobStatuses.get(0)).getEventName();
    }

    public FlowStatus getFlowStatus(String flowName, String flowGroup, long flowExecutionId, String tag) {
        FlowStatus flowStatus = null;
        UnmodifiableIterator jobStatusIterator = this.jobStatusRetriever.getJobStatusesForFlowExecution(flowName, flowGroup, flowExecutionId);
        if (tag != null) {
            jobStatusIterator = Iterators.filter(jobStatusIterator, js -> JobStatusRetriever.isFlowStatus(js) || js.getJobTag() != null && js.getJobTag().equals(tag));
        }
        if (jobStatusIterator.hasNext()) {
            flowStatus = new FlowStatus(flowName, flowGroup, flowExecutionId, (Iterator<JobStatus>)jobStatusIterator);
        }
        return flowStatus;
    }

    public boolean isFlowRunning(String flowName, String flowGroup) {
        List<FlowStatus> flowStatusList = this.getLatestFlowStatus(flowName, flowGroup, 1, null);
        if (flowStatusList == null || flowStatusList.isEmpty()) {
            return false;
        }
        FlowStatus flowStatus = flowStatusList.get(0);
        Iterator<JobStatus> jobStatusIterator = flowStatus.getJobStatusIterator();
        while (jobStatusIterator.hasNext()) {
            JobStatus jobStatus = jobStatusIterator.next();
            if (!JobStatusRetriever.isFlowStatus(jobStatus)) continue;
            return this.isJobRunning(jobStatus);
        }
        return false;
    }

    private boolean isJobRunning(JobStatus jobStatus) {
        String status = jobStatus.getEventName().toUpperCase();
        return !FINISHED_STATUSES.contains(status);
    }

    public void killFlow(String flowGroup, String flowName, Long flowExecutionId) {
        this.eventBus.post((Object)new KillFlowEvent(flowGroup, flowName, flowExecutionId));
    }

    FlowStatusGenerator(JobStatusRetriever jobStatusRetriever, EventBus eventBus) {
        this.jobStatusRetriever = jobStatusRetriever;
        this.eventBus = eventBus;
    }

    public static FlowStatusGeneratorBuilder builder() {
        return new FlowStatusGeneratorBuilder();
    }

    public static class FlowStatusGeneratorBuilder {
        private JobStatusRetriever jobStatusRetriever;
        private EventBus eventBus;

        FlowStatusGeneratorBuilder() {
        }

        public FlowStatusGeneratorBuilder jobStatusRetriever(JobStatusRetriever jobStatusRetriever) {
            this.jobStatusRetriever = jobStatusRetriever;
            return this;
        }

        public FlowStatusGeneratorBuilder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public FlowStatusGenerator build() {
            return new FlowStatusGenerator(this.jobStatusRetriever, this.eventBus);
        }

        public String toString() {
            return "FlowStatusGenerator.FlowStatusGeneratorBuilder(jobStatusRetriever=" + this.jobStatusRetriever + ", eventBus=" + this.eventBus + ")";
        }
    }
}

