/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.mapreduce;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.runtime.mapreduce.MRJobLauncher;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinWorkUnitsInputFormat
extends InputFormat<LongWritable, Text> {
    private static final Logger log = LoggerFactory.getLogger(GobblinWorkUnitsInputFormat.class);
    private static final String MAX_MAPPERS = GobblinWorkUnitsInputFormat.class.getName() + ".maxMappers";

    public static void setMaxMappers(Job job, int maxMappers) {
        job.getConfiguration().setInt(MAX_MAPPERS, maxMappers);
    }

    public static int getMaxMapper(Configuration conf) {
        return conf.getInt(MAX_MAPPERS, Integer.MAX_VALUE);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Path[] inputPaths = FileInputFormat.getInputPaths((JobContext)context);
        if (inputPaths == null || inputPaths.length == 0) {
            throw new IOException("No input found!");
        }
        ArrayList allPaths = Lists.newArrayList();
        for (Path path : inputPaths) {
            FileSystem fs = path.getFileSystem(context.getConfiguration());
            Object[] inputs = fs.listStatus(path);
            if (inputs == null) {
                throw new IOException(String.format("Path %s does not exist.", path));
            }
            log.info(String.format("Found %d input files at %s: %s", inputs.length, path, Arrays.toString(inputs)));
            for (Object input : inputs) {
                allPaths.add(input.getPath().toString());
            }
        }
        int maxMappers = GobblinWorkUnitsInputFormat.getMaxMapper(context.getConfiguration());
        int numTasksPerMapper = allPaths.size() % maxMappers == 0 ? allPaths.size() / maxMappers : allPaths.size() / maxMappers + 1;
        ArrayList splits = Lists.newArrayList();
        Iterator pathsIt = allPaths.iterator();
        while (pathsIt.hasNext()) {
            Iterator limitedIterator = Iterators.limit(pathsIt, (int)numTasksPerMapper);
            splits.add(new GobblinSplit(Lists.newArrayList((Iterator)limitedIterator)));
        }
        return splits;
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new GobblinRecordReader((GobblinSplit)split);
    }

    public static class GobblinRecordReader
    extends RecordReader<LongWritable, Text> {
        private static final String READER_PROGRESS_FACTOR = "mapper.readerProgressFactor";
        private static final float DEFAULT_READER_PROGRESS_FACTOR = 0.1f;
        private int currentIdx = -1;
        private final List<String> paths;
        private final int totalPaths;
        private Properties properties;

        public GobblinRecordReader(GobblinSplit split) {
            this.paths = split.getPaths();
            this.totalPaths = this.paths.size();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.properties = HadoopUtils.getStateFromConf((Configuration)context.getConfiguration()).getProperties();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            ++this.currentIdx;
            return this.currentIdx < this.totalPaths;
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return new LongWritable((long)this.currentIdx);
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return new Text(this.paths.get(this.currentIdx));
        }

        public float getProgress() throws IOException, InterruptedException {
            if (MRJobLauncher.isCustomizedProgressReportEnabled(this.properties)) {
                return 0.0f;
            }
            float factor = this.properties.containsKey(READER_PROGRESS_FACTOR) ? Float.parseFloat(this.properties.getProperty(READER_PROGRESS_FACTOR)) : 0.1f;
            return factor * ((float)this.currentIdx / (float)this.totalPaths);
        }

        public void close() throws IOException {
        }
    }

    public static class GobblinSplit
    extends InputSplit
    implements Writable {
        private List<String> paths;

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.paths.size());
            for (String path : this.paths) {
                out.writeUTF(path);
            }
        }

        public void readFields(DataInput in) throws IOException {
            int numPaths = in.readInt();
            this.paths = Lists.newArrayList();
            for (int i = 0; i < numPaths; ++i) {
                this.paths.add(in.readUTF());
            }
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public static GobblinSplitBuilder builder() {
            return new GobblinSplitBuilder();
        }

        @ConstructorProperties(value={"paths"})
        public GobblinSplit(List<String> paths) {
            this.paths = paths;
        }

        public GobblinSplit() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GobblinSplit)) {
                return false;
            }
            GobblinSplit other = (GobblinSplit)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            List<String> this$paths = this.getPaths();
            List<String> other$paths = other.getPaths();
            return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GobblinSplit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $paths = this.getPaths();
            result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
            return result;
        }

        public List<String> getPaths() {
            return this.paths;
        }

        public static class GobblinSplitBuilder {
            private ArrayList<String> paths;

            GobblinSplitBuilder() {
            }

            public GobblinSplitBuilder path(String path) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.add(path);
                return this;
            }

            public GobblinSplitBuilder paths(Collection<? extends String> paths) {
                if (this.paths == null) {
                    this.paths = new ArrayList();
                }
                this.paths.addAll(paths);
                return this;
            }

            public GobblinSplitBuilder clearPaths() {
                if (this.paths != null) {
                    this.paths.clear();
                }
                return this;
            }

            public GobblinSplit build() {
                List<String> paths;
                switch (this.paths == null ? 0 : this.paths.size()) {
                    case 0: {
                        paths = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        paths = Collections.singletonList(this.paths.get(0));
                        break;
                    }
                    default: {
                        paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                    }
                }
                return new GobblinSplit(paths);
            }

            public String toString() {
                return "GobblinWorkUnitsInputFormat.GobblinSplit.GobblinSplitBuilder(paths=" + this.paths + ")";
            }
        }
    }
}

