/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.MutableJobCatalogBase;
import org.slf4j.Logger;

public class InMemoryJobCatalog
extends MutableJobCatalogBase {
    protected final Map<URI, JobSpec> jobSpecs = new HashMap<URI, JobSpec>();

    public InMemoryJobCatalog() {
        this((Optional<Logger>)Optional.absent());
    }

    public InMemoryJobCatalog(Optional<Logger> log) {
        this(log, (Optional<MetricContext>)Optional.absent(), true);
    }

    public InMemoryJobCatalog(GobblinInstanceEnvironment env) {
        this((Optional<Logger>)Optional.of((Object)env.getLog()), (Optional<MetricContext>)Optional.of((Object)env.getMetricContext()), env.isInstrumentationEnabled());
    }

    public InMemoryJobCatalog(Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) {
        super(log, parentMetricContext, instrumentationEnabled);
    }

    @Override
    public synchronized Collection<JobSpec> getJobs() {
        return new ArrayList<JobSpec>(this.jobSpecs.values());
    }

    @Override
    public synchronized JobSpec getJobSpec(URI uri) throws JobSpecNotFoundException {
        if (this.jobSpecs.containsKey(uri)) {
            return this.jobSpecs.get(uri);
        }
        throw new JobSpecNotFoundException(uri);
    }

    @Override
    protected JobSpec doPut(JobSpec jobSpec) {
        return this.jobSpecs.put(jobSpec.getUri(), jobSpec);
    }

    @Override
    protected JobSpec doRemove(URI uri) {
        return this.jobSpecs.remove(uri);
    }
}

