/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Objects;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.util.callbacks.Callback;

public interface JobSpecSchedulerListener {
    public void onJobScheduled(JobSpecSchedule var1);

    public void onJobUnscheduled(JobSpecSchedule var1);

    public void onJobTriggered(JobSpec var1);

    public static class JobTriggeredCallback
    extends Callback<JobSpecSchedulerListener, Void> {
        private final JobSpec _jobSpec;

        public JobTriggeredCallback(JobSpec jobSpec) {
            super(Objects.toStringHelper((String)"onJobTriggered").add("jobSpec", (Object)jobSpec).toString());
            this._jobSpec = jobSpec;
        }

        public Void apply(JobSpecSchedulerListener listener) {
            listener.onJobTriggered(this._jobSpec);
            return null;
        }
    }

    public static class JobUnscheduledCallback
    extends Callback<JobSpecSchedulerListener, Void> {
        private final JobSpecSchedule _jobSchedule;

        public JobUnscheduledCallback(JobSpecSchedule jobSchedule) {
            super(Objects.toStringHelper((String)"onJobUnscheduled").add("jobSchedule", (Object)jobSchedule).toString());
            this._jobSchedule = jobSchedule;
        }

        public Void apply(JobSpecSchedulerListener listener) {
            listener.onJobUnscheduled(this._jobSchedule);
            return null;
        }
    }

    public static class JobScheduledCallback
    extends Callback<JobSpecSchedulerListener, Void> {
        private final JobSpecSchedule _jobSchedule;

        public JobScheduledCallback(JobSpecSchedule jobSchedule) {
            super(Objects.toStringHelper((String)"onJobScheduled").add("jobSchedule", (Object)jobSchedule).toString());
            this._jobSchedule = jobSchedule;
        }

        public Void apply(JobSpecSchedulerListener listener) {
            listener.onJobScheduled(this._jobSchedule);
            return null;
        }
    }
}

