/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.scheduler;

import com.google.common.util.concurrent.Service;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.gobblin.runtime.app.ServiceBasedAppLauncher;
import org.apache.gobblin.scheduler.JobScheduler;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerDaemon
extends ServiceBasedAppLauncher {
    private static final Logger log = LoggerFactory.getLogger(SchedulerDaemon.class);

    private SchedulerDaemon(Properties defaultProperties, Properties customProperties) throws Exception {
        this(PropertiesUtils.combineProperties((Properties[])new Properties[]{defaultProperties, customProperties}));
    }

    public SchedulerDaemon(Properties properties) throws Exception {
        super(properties, SchedulerDaemon.getAppName(properties));
        SchedulerService schedulerService = new SchedulerService(properties);
        this.addService((Service)schedulerService);
        this.addService((Service)new JobScheduler(properties, schedulerService));
    }

    private static String getAppName(Properties properties) {
        return properties.getProperty("app.name", "SchedulerDaemon-" + UUID.randomUUID());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: SchedulerDaemon <default configuration properties file> [custom configuration properties file]");
            System.exit(1);
        }
        Properties defaultProperties = ConfigurationConverter.getProperties((Configuration)new PropertiesConfiguration(args[0]));
        Properties customProperties = new Properties();
        if (args.length == 2) {
            customProperties.putAll((Map<?, ?>)ConfigurationConverter.getProperties((Configuration)new PropertiesConfiguration(args[1])));
        }
        log.debug("Scheduler Daemon::main starting with defaultProperties: {}, customProperties: {}", (Object)defaultProperties, (Object)customProperties);
        new SchedulerDaemon(defaultProperties, customProperties).start();
    }
}

