/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.JobMetrics;

public class TaskMetrics
extends GobblinMetrics {
    protected final String jobId;

    protected TaskMetrics(TaskState taskState) {
        super(TaskMetrics.name(taskState), TaskMetrics.parentContextForTask(taskState), TaskMetrics.tagsForTask(taskState));
        this.jobId = taskState.getJobId();
    }

    public static TaskMetrics get(final TaskState taskState) {
        return (TaskMetrics)GOBBLIN_METRICS_REGISTRY.getOrDefault(TaskMetrics.name(taskState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new TaskMetrics(taskState);
            }
        });
    }

    public static void remove(TaskState taskState) {
        TaskMetrics.remove((String)TaskMetrics.name(taskState));
    }

    private static String name(TaskState taskState) {
        return "gobblin.metrics." + taskState.getJobId() + "." + taskState.getTaskId();
    }

    protected static List<Tag<?>> tagsForTask(TaskState taskState) {
        ArrayList tags = Lists.newArrayList();
        tags.add(new Tag("taskId", (Object)taskState.getTaskId()));
        tags.add(new Tag("taskAttemptId", taskState.getTaskAttemptId().or((Object)"")));
        tags.add(new Tag("dataset.urn", (Object)taskState.getProp("dataset.urn", "")));
        tags.addAll(TaskMetrics.getCustomTagsFromState((State)taskState));
        return tags;
    }

    private static MetricContext parentContextForTask(TaskState taskState) {
        return JobMetrics.get(taskState.getProp("job.name"), taskState.getJobId()).getMetricContext();
    }

    public static String taskInstanceRemoved(String metricName) {
        String METRIC_SEPARATOR = "_";
        String[] taskIdTokens = metricName.split("_");
        StringBuilder sb = new StringBuilder(taskIdTokens[0]);
        for (int i = 1; i < taskIdTokens.length - 2; ++i) {
            sb.append("_").append(taskIdTokens[i]);
        }
        return sb.toString();
    }
}

