/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.template.InheritingJobTemplate;

public class StaticJobTemplate
extends InheritingJobTemplate {
    public static final String SUPER_TEMPLATE_KEY = "gobblin.template.inherit";
    private Config rawConfig;
    private Set<String> requiredAttributes;
    private final URI uri;
    private final String version;
    private final String description;
    private Collection<String> dependencies;

    public StaticJobTemplate(URI uri, String version, String description, Config config, JobCatalogWithTemplates catalog) throws SpecNotFoundException, JobTemplate.TemplateException {
        this(uri, version, description, config, StaticJobTemplate.getSuperTemplateUris(config), catalog);
    }

    protected StaticJobTemplate(URI uri, String version, String description, Config config, List<URI> superTemplateUris, JobCatalogWithTemplates catalog) throws SpecNotFoundException, JobTemplate.TemplateException {
        super(superTemplateUris, catalog);
        this.uri = uri;
        this.version = version;
        this.description = description;
        this.rawConfig = config;
        this.requiredAttributes = config.hasPath("gobblin.template.required_attributes") ? new HashSet<String>(Arrays.asList(config.getString("gobblin.template.required_attributes").split(","))) : Sets.newHashSet();
        this.dependencies = config.hasPath("job.dependencies") ? Arrays.asList(config.getString("job.dependencies").split(",")) : new ArrayList<String>();
    }

    private static List<URI> getSuperTemplateUris(Config config) throws JobTemplate.TemplateException {
        if (config.hasPath(SUPER_TEMPLATE_KEY)) {
            ArrayList uris = Lists.newArrayList();
            for (String uriString : config.getString(SUPER_TEMPLATE_KEY).split(",")) {
                try {
                    uris.add(new URI(uriString));
                }
                catch (URISyntaxException use) {
                    throw new JobTemplate.TemplateException("Super template uri is malformed: " + uriString, use);
                }
            }
            return uris;
        }
        return Lists.newArrayList();
    }

    @Override
    protected Config getLocalRawTemplate() {
        return this.rawConfig;
    }

    @Override
    protected Collection<String> getLocallyRequiredConfigList() {
        return this.requiredAttributes;
    }

    @Override
    protected Config getLocallyResolvedConfig(Config userConfig) {
        return userConfig.withFallback((ConfigMergeable)this.rawConfig);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }
}

