/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.util.CompletedFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySpecProducer
implements SpecProducer<Spec>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(InMemorySpecProducer.class);
    private final Map<URI, Spec> provisionedSpecs;
    private transient Config config;
    private static final long serialVersionUID = 6106269076155338045L;

    public InMemorySpecProducer(Config config) {
        this.config = config;
        this.provisionedSpecs = Maps.newHashMap();
    }

    public Future<?> addSpec(Spec addedSpec) {
        this.provisionedSpecs.put(addedSpec.getUri(), addedSpec);
        log.info(String.format("Added Spec: %s with Uri: %s for execution on this executor.", addedSpec, addedSpec.getUri()));
        return new CompletedFuture((Object)Boolean.TRUE, null);
    }

    public Future<?> updateSpec(Spec updatedSpec) {
        if (!this.provisionedSpecs.containsKey(updatedSpec.getUri())) {
            throw new RuntimeException("Spec not found: " + updatedSpec.getUri());
        }
        this.provisionedSpecs.put(updatedSpec.getUri(), updatedSpec);
        log.info(String.format("Updated Spec: %s with Uri: %s for execution on this executor.", updatedSpec, updatedSpec.getUri()));
        return new CompletedFuture((Object)Boolean.TRUE, null);
    }

    public Future<?> deleteSpec(URI deletedSpecURI, Properties headers) {
        if (!this.provisionedSpecs.containsKey(deletedSpecURI)) {
            throw new RuntimeException("Spec not found: " + deletedSpecURI);
        }
        this.provisionedSpecs.remove(deletedSpecURI);
        log.info(String.format("Deleted Spec with Uri: %s from this executor.", deletedSpecURI));
        return new CompletedFuture((Object)Boolean.TRUE, null);
    }

    public Future<? extends List<Spec>> listSpecs() {
        return new CompletedFuture((Object)Lists.newArrayList(this.provisionedSpecs.values()), null);
    }
}

