/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.api.SpecCatalogListenersContainer;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SpecCatalog
extends SpecCatalogListenersContainer,
Instrumentable,
StandardMetricsBridge {
    public Collection<Spec> getSpecs();

    public StandardMetrics getMetrics();

    default public Collection<StandardMetricsBridge.StandardMetrics> getStandardMetricsCollection() {
        StandardMetrics standardMetrics = this.getMetrics();
        return standardMetrics == null ? ImmutableList.of() : ImmutableList.of((Object)standardMetrics);
    }

    public Spec getSpec(URI var1) throws SpecNotFoundException;

    public static class StandardMetrics
    extends StandardMetricsBridge.StandardMetrics
    implements SpecCatalogListener {
        private static final Logger log = LoggerFactory.getLogger(StandardMetrics.class);
        public static final String NUM_ACTIVE_SPECS_NAME = "numActiveSpecs";
        public static final String TOTAL_ADD_CALLS = "totalAddCalls";
        public static final String TOTAL_DELETE_CALLS = "totalDeleteCalls";
        public static final String TOTAL_UPDATE_CALLS = "totalUpdateCalls";
        public static final String TRACKING_EVENT_NAME = "SpecCatalogEvent";
        public static final String SPEC_ADDED_OPERATION_TYPE = "SpecAdded";
        public static final String SPEC_DELETED_OPERATION_TYPE = "SpecDeleted";
        public static final String SPEC_UPDATED_OPERATION_TYPE = "SpecUpdated";
        public static final String TIME_FOR_SPEC_CATALOG_GET = "timeForSpecCatalogGet";
        private final MetricContext metricsContext;
        protected final int timeWindowSizeInMinutes;
        private final AtomicLong totalAddedSpecs;
        private final AtomicLong totalDeletedSpecs;
        private final AtomicLong totalUpdatedSpecs;
        private final ContextAwareGauge<Long> totalAddCalls;
        private final ContextAwareGauge<Long> totalDeleteCalls;
        private final ContextAwareGauge<Long> totalUpdateCalls;
        private final ContextAwareGauge<Integer> numActiveSpecs;
        private final ContextAwareTimer timeForSpecCatalogGet;

        public StandardMetrics(SpecCatalog specCatalog, Optional<Config> sysConfig) {
            this.timeWindowSizeInMinutes = sysConfig.isPresent() ? ConfigUtils.getInt((Config)((Config)sysConfig.get()), (String)"metrics.timer.window.size.in.minutes", (Integer)15) : 15;
            this.metricsContext = specCatalog.getMetricContext();
            this.timeForSpecCatalogGet = this.metricsContext.contextAwareTimer(TIME_FOR_SPEC_CATALOG_GET, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.totalAddedSpecs = new AtomicLong(0L);
            this.totalDeletedSpecs = new AtomicLong(0L);
            this.totalUpdatedSpecs = new AtomicLong(0L);
            this.numActiveSpecs = this.metricsContext.newContextAwareGauge(NUM_ACTIVE_SPECS_NAME, () -> {
                long startTime = System.currentTimeMillis();
                int size = specCatalog.getSpecs().size();
                this.updateGetSpecTime(startTime);
                return size;
            });
            this.totalAddCalls = this.metricsContext.newContextAwareGauge(TOTAL_ADD_CALLS, () -> this.totalAddedSpecs.get());
            this.totalUpdateCalls = this.metricsContext.newContextAwareGauge(TOTAL_UPDATE_CALLS, () -> this.totalUpdatedSpecs.get());
            this.totalDeleteCalls = this.metricsContext.newContextAwareGauge(TOTAL_DELETE_CALLS, () -> this.totalDeletedSpecs.get());
            this.contextAwareMetrics.add(this.numActiveSpecs);
            this.contextAwareMetrics.add(this.totalAddCalls);
            this.contextAwareMetrics.add(this.totalUpdateCalls);
            this.contextAwareMetrics.add(this.totalDeleteCalls);
            this.contextAwareMetrics.add(this.timeForSpecCatalogGet);
        }

        public void updateGetSpecTime(long startTime) {
            log.info("updateGetSpecTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForSpecCatalogGet), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        @Override
        public void onAddSpec(Spec addedSpec) {
            this.totalAddedSpecs.incrementAndGet();
            this.submitTrackingEvent(addedSpec, SPEC_ADDED_OPERATION_TYPE);
        }

        private void submitTrackingEvent(Spec spec, String operType) {
            this.submitTrackingEvent(spec.getUri(), spec.getVersion(), operType);
        }

        private void submitTrackingEvent(URI specSpecURI, String specSpecVersion, String operType) {
            GobblinTrackingEvent e = GobblinTrackingEvent.newBuilder().setName(TRACKING_EVENT_NAME).setNamespace(SpecCatalog.class.getName()).setMetadata((Map)ImmutableMap.builder().put((Object)"operationType", (Object)operType).put((Object)"flowSpecURI", (Object)specSpecURI.toString()).put((Object)"flowSpecVersion", (Object)specSpecVersion).build()).build();
            this.metricsContext.submitEvent(e);
        }

        @Override
        public void onDeleteSpec(URI deletedSpecURI, String deletedSpecVersion, Properties headers) {
            this.totalDeletedSpecs.incrementAndGet();
            this.submitTrackingEvent(deletedSpecURI, deletedSpecVersion, SPEC_DELETED_OPERATION_TYPE);
        }

        @Override
        public void onUpdateSpec(Spec updatedSpec) {
            this.totalUpdatedSpecs.incrementAndGet();
            this.submitTrackingEvent(updatedSpec, SPEC_UPDATED_OPERATION_TYPE);
        }

        public AtomicLong getTotalAddedSpecs() {
            return this.totalAddedSpecs;
        }

        public AtomicLong getTotalDeletedSpecs() {
            return this.totalDeletedSpecs;
        }

        public AtomicLong getTotalUpdatedSpecs() {
            return this.totalUpdatedSpecs;
        }

        public ContextAwareGauge<Long> getTotalAddCalls() {
            return this.totalAddCalls;
        }

        public ContextAwareGauge<Long> getTotalDeleteCalls() {
            return this.totalDeleteCalls;
        }

        public ContextAwareGauge<Long> getTotalUpdateCalls() {
            return this.totalUpdateCalls;
        }

        public ContextAwareGauge<Integer> getNumActiveSpecs() {
            return this.numActiveSpecs;
        }

        public ContextAwareTimer getTimeForSpecCatalogGet() {
            return this.timeForSpecCatalogGet;
        }
    }
}

