/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.TaskMetrics;
import org.apache.gobblin.util.ClustersNames;

public class JobMetrics
extends GobblinMetrics {
    protected final String jobName;

    protected JobMetrics(JobState job) {
        this(job, null);
    }

    protected JobMetrics(JobState job, MetricContext parentContext) {
        super(JobMetrics.name(job), parentContext, JobMetrics.tagsForJob(job));
        this.jobName = job.getJobName();
    }

    public static JobMetrics get(String jobName, String jobId) {
        return JobMetrics.get(new JobState(jobName, jobId));
    }

    public static JobMetrics get(String jobId) {
        return JobMetrics.get(null, jobId);
    }

    public static JobMetrics get(final JobState jobState, final MetricContext parentContext) {
        return (JobMetrics)GOBBLIN_METRICS_REGISTRY.getOrDefault(JobMetrics.name(jobState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new JobMetrics(jobState, parentContext);
            }
        });
    }

    public static JobMetrics get(final JobState jobState) {
        return (JobMetrics)GOBBLIN_METRICS_REGISTRY.getOrDefault(JobMetrics.name(jobState), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new JobMetrics(jobState);
            }
        });
    }

    public static void remove(JobState jobState) {
        JobMetrics.remove((String)JobMetrics.name(jobState));
        for (TaskState taskState : jobState.getTaskStates()) {
            TaskMetrics.remove(taskState);
        }
    }

    private static String name(JobState jobState) {
        return "gobblin.metrics." + jobState.getJobId();
    }

    private static List<Tag<?>> tagsForJob(JobState jobState) {
        ArrayList tags = Lists.newArrayList();
        tags.add(new Tag("jobName", (Object)(jobState.getJobName() == null ? "" : jobState.getJobName())));
        tags.add(new Tag("jobId", (Object)jobState.getJobId()));
        tags.addAll(JobMetrics.getCustomTagsFromState((State)jobState));
        return tags;
    }

    @Deprecated
    public static String getClusterIdentifierTag() {
        return ClustersNames.getInstance().getClusterName();
    }
}

