/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.api.Configurable;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;

@Alpha
public interface GobblinInstanceLauncher
extends Service,
Configurable,
GobblinInstanceEnvironment {
    public GobblinInstanceDriver getDriver() throws IllegalStateException;

    public static class ConfigAccessor {
        static final String RESOURCE_NAME = GobblinInstanceLauncher.class.getPackage().getName().replaceAll("[.]", "/") + "/" + GobblinInstanceLauncher.class.getSimpleName() + ".conf";
        static final String CONFIG_PREFIX = "gobblin.instance";
        static final String START_TIMEOUT_MS = "startTimeoutMs";
        static final String SHUTDOWN_TIMEOUT_MS = "shutdownTimeoutMs";
        private final long startTimeoutMs;
        private final long shutdownTimeoutMs;

        public ConfigAccessor(Config cfg) {
            Config effectiveCfg = cfg.withFallback((ConfigMergeable)ConfigAccessor.getDefaultConfig().getConfig(CONFIG_PREFIX));
            this.startTimeoutMs = effectiveCfg.getLong(START_TIMEOUT_MS);
            this.shutdownTimeoutMs = effectiveCfg.getLong(SHUTDOWN_TIMEOUT_MS);
        }

        public static Config getDefaultConfig() {
            return ConfigFactory.parseResources(GobblinInstanceLauncher.class, (String)(GobblinInstanceLauncher.class.getSimpleName() + ".conf")).withFallback((ConfigMergeable)ConfigFactory.load());
        }

        public static ConfigAccessor createFromGlobalConfig(Config cfg) {
            Config localCfg = cfg.hasPath(CONFIG_PREFIX) ? cfg.getConfig(CONFIG_PREFIX) : ConfigFactory.empty();
            return new ConfigAccessor(localCfg);
        }

        public long getStartTimeoutMs() {
            return this.startTimeoutMs;
        }

        public long getShutdownTimeoutMs() {
            return this.shutdownTimeoutMs;
        }
    }
}

