/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.typesafe.config.Config;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.MysqlDataSourceFactory;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.MysqlDatasetStateStore;

@Alias(value="mysql")
public class MysqlDatasetStateStoreFactory
implements DatasetStateStore.Factory {
    public DatasetStateStore<JobState.DatasetState> createStateStore(Config config) {
        String stateStoreTableName = config.hasPath("state.store.db.table") ? config.getString("state.store.db.table") : "gobblin_job_state";
        boolean compressedValues = config.hasPath("state.store.compressedValues") ? config.getBoolean("state.store.compressedValues") : true;
        try {
            BasicDataSource basicDataSource = MysqlDataSourceFactory.get((Config)config, (SharedResourcesBroker)SharedResourcesBrokerFactory.getImplicitBroker());
            return new MysqlDatasetStateStore((DataSource)basicDataSource, stateStoreTableName, compressedValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create MysqlDatasetStateStore with factory", e);
        }
    }
}

