/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.template;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.PackagedTemplatesJobCatalogDecorator;
import org.apache.gobblin.runtime.template.HOCONInputStreamJobTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBasedJobTemplate
extends HOCONInputStreamJobTemplate {
    private static final Logger log = LoggerFactory.getLogger(ResourceBasedJobTemplate.class);
    public static final String SCHEME = "resource";

    public static ResourceBasedJobTemplate forURI(URI uri, JobCatalogWithTemplates catalog) throws SpecNotFoundException, JobTemplate.TemplateException, IOException {
        try (InputStream is = ResourceBasedJobTemplate.getInputStreamForURI(uri);){
            ResourceBasedJobTemplate resourceBasedJobTemplate = new ResourceBasedJobTemplate(is, uri, catalog);
            return resourceBasedJobTemplate;
        }
    }

    public static ResourceBasedJobTemplate forResourcePath(String path) throws SpecNotFoundException, JobTemplate.TemplateException, IOException, URISyntaxException {
        return ResourceBasedJobTemplate.forResourcePath(path, new PackagedTemplatesJobCatalogDecorator());
    }

    public static ResourceBasedJobTemplate forResourcePath(String path, JobCatalogWithTemplates catalog) throws SpecNotFoundException, JobTemplate.TemplateException, IOException, URISyntaxException {
        return ResourceBasedJobTemplate.forURI(new URI(path), catalog);
    }

    private ResourceBasedJobTemplate(InputStream is, URI uri, JobCatalogWithTemplates catalog) throws SpecNotFoundException, JobTemplate.TemplateException, IOException {
        super(is, uri, catalog);
    }

    private static InputStream getInputStreamForURI(URI uri) throws IOException {
        InputStream is;
        Preconditions.checkArgument((uri.getScheme() == null || uri.getScheme().equals(SCHEME) ? 1 : 0) != 0, (Object)("Unexpected template scheme: " + uri));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uri.getPath()) ? 1 : 0) != 0, (Object)("Template path is null: " + uri));
        log.info("Loading the resource based job configuration template " + uri);
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((is = ResourceBasedJobTemplate.class.getClassLoader().getResourceAsStream(path)) == null) {
            throw new IOException(String.format("Could not find resource at path %s required to load template %s.", path, uri));
        }
        return is;
    }
}

