/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;

public class DefaultJobSpecScheduleImpl
implements JobSpecSchedule {
    private final JobSpec jobSpec;
    private final Runnable jobRunnable;
    private final Optional<Long> nextRunTimeMillis;

    public static DefaultJobSpecScheduleImpl createImmediateSchedule(JobSpec jobSpec, Runnable jobRunnable) {
        return new DefaultJobSpecScheduleImpl(jobSpec, jobRunnable, (Optional<Long>)Optional.of((Object)System.currentTimeMillis()));
    }

    public static DefaultJobSpecScheduleImpl createNoSchedule(JobSpec jobSpec, Runnable jobRunnable) {
        return new DefaultJobSpecScheduleImpl(jobSpec, jobRunnable, (Optional<Long>)Optional.absent());
    }

    @ConstructorProperties(value={"jobSpec", "jobRunnable", "nextRunTimeMillis"})
    public DefaultJobSpecScheduleImpl(JobSpec jobSpec, Runnable jobRunnable, Optional<Long> nextRunTimeMillis) {
        this.jobSpec = jobSpec;
        this.jobRunnable = jobRunnable;
        this.nextRunTimeMillis = nextRunTimeMillis;
    }

    @Override
    public JobSpec getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public Runnable getJobRunnable() {
        return this.jobRunnable;
    }

    @Override
    public Optional<Long> getNextRunTimeMillis() {
        return this.nextRunTimeMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultJobSpecScheduleImpl)) {
            return false;
        }
        DefaultJobSpecScheduleImpl other = (DefaultJobSpecScheduleImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobSpec this$jobSpec = this.getJobSpec();
        JobSpec other$jobSpec = other.getJobSpec();
        if (this$jobSpec == null ? other$jobSpec != null : !((Object)this$jobSpec).equals(other$jobSpec)) {
            return false;
        }
        Runnable this$jobRunnable = this.getJobRunnable();
        Runnable other$jobRunnable = other.getJobRunnable();
        if (this$jobRunnable == null ? other$jobRunnable != null : !this$jobRunnable.equals(other$jobRunnable)) {
            return false;
        }
        Optional<Long> this$nextRunTimeMillis = this.getNextRunTimeMillis();
        Optional<Long> other$nextRunTimeMillis = other.getNextRunTimeMillis();
        return !(this$nextRunTimeMillis == null ? other$nextRunTimeMillis != null : !this$nextRunTimeMillis.equals(other$nextRunTimeMillis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultJobSpecScheduleImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobSpec $jobSpec = this.getJobSpec();
        result = result * 59 + ($jobSpec == null ? 43 : ((Object)$jobSpec).hashCode());
        Runnable $jobRunnable = this.getJobRunnable();
        result = result * 59 + ($jobRunnable == null ? 43 : $jobRunnable.hashCode());
        Optional<Long> $nextRunTimeMillis = this.getNextRunTimeMillis();
        result = result * 59 + ($nextRunTimeMillis == null ? 43 : $nextRunTimeMillis.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultJobSpecScheduleImpl(jobSpec=" + this.getJobSpec() + ", jobRunnable=" + this.getJobRunnable() + ", nextRunTimeMillis=" + this.getNextRunTimeMillis() + ")";
    }
}

