/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Optional;
import java.net.URI;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.slf4j.Logger;

public class DefaultJobCatalogListenerImpl
implements JobCatalogListener {
    protected final Optional<Logger> _log;

    public DefaultJobCatalogListenerImpl(Optional<Logger> log) {
        this._log = log;
    }

    public DefaultJobCatalogListenerImpl(Logger log) {
        this((Optional<Logger>)Optional.of((Object)log));
    }

    public DefaultJobCatalogListenerImpl() {
        this((Optional<Logger>)Optional.absent());
    }

    @Override
    public void onAddJob(JobSpec addedJob) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("New JobSpec detected: " + addedJob.toShortString());
        }
    }

    @Override
    public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobSpec deleted: " + deletedJobURI + "/" + deletedJobVersion);
        }
    }

    @Override
    public void onUpdateJob(JobSpec updatedJob) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobSpec changed: " + updatedJob.toShortString());
        }
    }
}

