/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.AvroOrcSchemaConverter;
import org.apache.gobblin.writer.FsDataWriterBuilder;
import org.apache.gobblin.writer.GenericRecordToOrcValueWriter;
import org.apache.gobblin.writer.GobblinBaseOrcWriter;
import org.apache.gobblin.writer.OrcValueWriter;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinOrcWriter
extends GobblinBaseOrcWriter<Schema, GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(GobblinOrcWriter.class);

    public GobblinOrcWriter(FsDataWriterBuilder<Schema, GenericRecord> builder, State properties) throws IOException {
        super(builder, properties);
    }

    @Override
    protected TypeDescription getOrcSchema() {
        return AvroOrcSchemaConverter.getOrcSchema((Schema)this.inputSchema);
    }

    @Override
    protected OrcValueWriter<GenericRecord> getOrcValueWriter(TypeDescription typeDescription, Schema inputSchema, State state) {
        return new GenericRecordToOrcValueWriter(typeDescription, (Schema)this.inputSchema, this.properties);
    }

    @Override
    protected Properties getPropsWithOrcSchema() throws SerDeException {
        Properties properties = new Properties();
        properties.setProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), ((Schema)this.inputSchema).toString());
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator((Schema)this.inputSchema);
        properties.setProperty("columns", StringUtils.join((Iterable)aoig.getColumnNames(), (String)","));
        properties.setProperty("columns.types", StringUtils.join((Iterable)aoig.getColumnTypes(), (String)","));
        return properties;
    }

    public boolean isSpeculativeAttemptSafe() {
        return this.writerAttemptIdOptional.isPresent() && ((Object)((Object)this)).getClass() == GobblinOrcWriter.class;
    }
}

