/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.AvroOrcSchemaConverter;
import org.apache.gobblin.writer.OrcValueWriter;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.UnionColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRecordToOrcValueWriter
implements OrcValueWriter<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(GenericRecordToOrcValueWriter.class);
    private static final String ENABLE_SMART_ARRAY_ENLARGE = "orcWriter.enabledMulValueColumnVectorSmartSizing";
    private static final boolean DEFAULT_ENABLE_SMART_ARRAY_ENLARGE = false;
    private static final String ENLARGE_FACTOR_KEY = "orcWriter.enlargeFactor";
    private static final int DEFAULT_ENLARGE_FACTOR = 3;
    private boolean enabledSmartSizing;
    private int enlargeFactor;
    @VisibleForTesting
    public int resizeCount = 0;
    private final Converter[] converters;

    public GenericRecordToOrcValueWriter(TypeDescription typeDescription, Schema avroSchema) {
        this.converters = this.buildConverters(typeDescription, avroSchema);
        this.enabledSmartSizing = false;
        this.enlargeFactor = 3;
    }

    public GenericRecordToOrcValueWriter(TypeDescription typeDescription, Schema avroSchema, State state) {
        this(typeDescription, avroSchema);
        this.enabledSmartSizing = state.getPropAsBoolean(ENABLE_SMART_ARRAY_ENLARGE, false);
        this.enlargeFactor = state.getPropAsInt(ENLARGE_FACTOR_KEY, 3);
    }

    @Override
    public void write(GenericRecord value, VectorizedRowBatch output) throws IOException {
        int row = output.size++;
        for (int c = 0; c < this.converters.length; ++c) {
            ColumnVector col = output.cols[c];
            if (value.get(c) == null) {
                col.noNulls = false;
                col.isNull[row] = true;
                continue;
            }
            col.isNull[row] = false;
            this.converters[c].addValue(row, c, value.get(c), col);
        }
    }

    private int resize(int rowsAdded, int batchSize, int currentSize) {
        ++this.resizeCount;
        log.info(String.format("It has been resized %s times in current writer", this.resizeCount));
        return this.enabledSmartSizing ? currentSize + (currentSize / rowsAdded + 1) * batchSize : this.enlargeFactor * currentSize;
    }

    private Converter buildConverter(TypeDescription schema, Schema avroSchema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case BYTE: {
                return new ByteConverter();
            }
            case SHORT: {
                return new ShortConverter();
            }
            case INT: {
                return new IntConverter();
            }
            case LONG: {
                return new LongConverter();
            }
            case FLOAT: {
                return new FloatConverter();
            }
            case DOUBLE: {
                return new DoubleConverter();
            }
            case BINARY: {
                return new BytesConverter();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringConverter();
            }
            case DECIMAL: {
                return new DecimalConverter();
            }
            case STRUCT: {
                return new StructConverter(schema, AvroOrcSchemaConverter.sanitizeNullableSchema(avroSchema));
            }
            case LIST: {
                return new ListConverter(schema, AvroOrcSchemaConverter.sanitizeNullableSchema(avroSchema));
            }
            case MAP: {
                return new MapConverter(schema, AvroOrcSchemaConverter.sanitizeNullableSchema(avroSchema));
            }
            case UNION: {
                return new UnionConverter(schema, AvroOrcSchemaConverter.sanitizeNullableSchema(avroSchema));
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private Converter[] buildConverters(TypeDescription schema, Schema avroSchema) {
        if (schema.getCategory() != TypeDescription.Category.STRUCT) {
            throw new IllegalArgumentException("Top level must be a struct " + schema);
        }
        List children = schema.getChildren();
        Converter[] result = new Converter[children.size()];
        for (int c = 0; c < children.size(); ++c) {
            result[c] = this.buildConverter((TypeDescription)children.get(c), ((Schema.Field)avroSchema.getFields().get(c)).schema());
        }
        return result;
    }

    class MapConverter
    implements Converter {
        private final Converter keyConverter;
        private final Converter valueConverter;
        private int rowsAdded;

        MapConverter(TypeDescription schema, Schema avroSchema) {
            this.keyConverter = GenericRecordToOrcValueWriter.this.buildConverter((TypeDescription)schema.getChildren().get(0), (Schema)SchemaBuilder.builder().stringType());
            this.valueConverter = GenericRecordToOrcValueWriter.this.buildConverter((TypeDescription)schema.getChildren().get(1), avroSchema.getValueType());
            this.rowsAdded = 0;
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ++this.rowsAdded;
            Map map = (Map)data;
            Set entries = map.entrySet();
            MapColumnVector cv = (MapColumnVector)output;
            cv.lengths[rowId] = entries.size();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            if (cv.childCount > cv.keys.isNull.length) {
                int resizedLength = GenericRecordToOrcValueWriter.this.resize(this.rowsAdded, cv.isNull.length, cv.childCount);
                cv.keys.ensureSize(resizedLength, true);
                cv.values.ensureSize(resizedLength, true);
            }
            int e = 0;
            for (Map.Entry entry : entries) {
                int offset = (int)((long)e + cv.offsets[rowId]);
                if (entry.getKey() == null) {
                    cv.keys.noNulls = false;
                    cv.keys.isNull[offset] = true;
                } else {
                    cv.keys.isNull[offset] = false;
                    this.keyConverter.addValue(offset, e, entry.getKey(), cv.keys);
                }
                if (entry.getValue() == null) {
                    cv.values.noNulls = false;
                    cv.values.isNull[offset] = true;
                } else {
                    cv.values.isNull[offset] = false;
                    this.valueConverter.addValue(offset, e, entry.getValue(), cv.values);
                }
                ++e;
            }
        }
    }

    class ListConverter
    implements Converter {
        private final Converter children;
        private int rowsAdded;

        ListConverter(TypeDescription schema, Schema avroSchema) {
            this.children = GenericRecordToOrcValueWriter.this.buildConverter((TypeDescription)schema.getChildren().get(0), avroSchema.getElementType());
            this.rowsAdded = 0;
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ++this.rowsAdded;
            List value = (List)data;
            ListColumnVector cv = (ListColumnVector)output;
            cv.lengths[rowId] = value.size();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            if (cv.childCount > cv.child.isNull.length) {
                int resizedLength = GenericRecordToOrcValueWriter.this.resize(this.rowsAdded, cv.isNull.length, cv.childCount);
                cv.child.ensureSize(resizedLength, true);
            }
            int e = 0;
            while ((long)e < cv.lengths[rowId]) {
                int offset = (int)((long)e + cv.offsets[rowId]);
                if (value.get(e) == null) {
                    cv.child.noNulls = false;
                    cv.child.isNull[offset] = true;
                } else {
                    cv.child.isNull[offset] = false;
                    this.children.addValue(offset, e, value.get(e), cv.child);
                }
                ++e;
            }
        }
    }

    class UnionConverter
    implements Converter {
        private final Converter[] children;
        private final Schema unionSchema;

        UnionConverter(TypeDescription schema, Schema avroSchema) {
            this.children = new Converter[schema.getChildren().size()];
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = GenericRecordToOrcValueWriter.this.buildConverter((TypeDescription)schema.getChildren().get(c), (Schema)avroSchema.getTypes().get(c));
            }
            this.unionSchema = avroSchema;
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            UnionColumnVector cv = (UnionColumnVector)output;
            int tag = data != null ? GenericData.get().resolveUnion(this.unionSchema, data) : this.children.length;
            for (int c = 0; c < this.children.length; ++c) {
                ColumnVector field = cv.fields[c];
                if (c == tag) {
                    field.isNull[rowId] = false;
                    cv.tags[rowId] = c;
                    this.children[c].addValue(rowId, c, data, field);
                    continue;
                }
                field.noNulls = false;
                field.isNull[rowId] = true;
            }
        }
    }

    class StructConverter
    implements Converter {
        private final Converter[] children;

        StructConverter(TypeDescription schema, Schema avroSchema) {
            this.children = new Converter[schema.getChildren().size()];
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = GenericRecordToOrcValueWriter.this.buildConverter((TypeDescription)schema.getChildren().get(c), ((Schema.Field)avroSchema.getFields().get(c)).schema());
            }
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            GenericRecord value = (GenericRecord)data;
            StructColumnVector cv = (StructColumnVector)output;
            for (int c = 0; c < this.children.length; ++c) {
                ColumnVector field = cv.fields[c];
                if (value.get(c) == null) {
                    field.noNulls = false;
                    field.isNull[rowId] = true;
                    continue;
                }
                field.isNull[rowId] = false;
                this.children[c].addValue(rowId, c, value.get(c), field);
            }
        }
    }

    static class DecimalConverter
    implements Converter {
        DecimalConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((DecimalColumnVector)output).vector[rowId].set(HiveDecimal.create((BigDecimal)((BigDecimal)data)));
        }
    }

    static class BytesConverter
    implements Converter {
        BytesConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            byte[] value = data instanceof GenericFixed ? ((GenericFixed)data).bytes() : (data instanceof ByteBuffer ? ((ByteBuffer)data).array() : (byte[])data);
            ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
        }
    }

    static class StringConverter
    implements Converter {
        StringConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            byte[] value = data instanceof GenericEnumSymbol ? data.toString().getBytes(StandardCharsets.UTF_8) : (data instanceof Enum ? ((Enum)data).name().getBytes(StandardCharsets.UTF_8) : (data instanceof Utf8 ? ((Utf8)data).getBytes() : ((String)data).getBytes(StandardCharsets.UTF_8)));
            ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
        }
    }

    static class DoubleConverter
    implements Converter {
        DoubleConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((DoubleColumnVector)output).vector[rowId] = (Double)data;
        }
    }

    static class FloatConverter
    implements Converter {
        FloatConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((DoubleColumnVector)output).vector[rowId] = ((Float)data).floatValue();
        }
    }

    static class LongConverter
    implements Converter {
        LongConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = (Long)data;
        }
    }

    static class IntConverter
    implements Converter {
        IntConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = ((Integer)data).intValue();
        }
    }

    static class ShortConverter
    implements Converter {
        ShortConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = ((Short)data).shortValue();
        }
    }

    static class ByteConverter
    implements Converter {
        ByteConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = ((Byte)data).byteValue();
        }
    }

    static class BooleanConverter
    implements Converter {
        BooleanConverter() {
        }

        @Override
        public void addValue(int rowId, int column, Object data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = (Boolean)data != false ? 1L : 0L;
        }
    }

    static interface Converter {
        public void addValue(int var1, int var2, Object var3, ColumnVector var4);
    }
}

