/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.orc.TypeDescription;

public class AvroOrcSchemaConverter {
    public static TypeDescription getOrcSchema(Schema avroSchema) {
        Schema.Type type = avroSchema.getType();
        switch (type) {
            case NULL: {
                TypeDescription nullUnion = TypeDescription.createUnion();
                return nullUnion;
            }
            case LONG: {
                return TypeDescription.createLong();
            }
            case INT: {
                return TypeDescription.createInt();
            }
            case BYTES: {
                return TypeDescription.createBinary();
            }
            case ARRAY: {
                return TypeDescription.createList((TypeDescription)AvroOrcSchemaConverter.getOrcSchema(avroSchema.getElementType()));
            }
            case RECORD: {
                TypeDescription recordStruct = TypeDescription.createStruct();
                for (Schema.Field field2 : avroSchema.getFields()) {
                    Schema fieldSchema = field2.schema();
                    TypeDescription fieldType = AvroOrcSchemaConverter.getOrcSchema(fieldSchema);
                    if (fieldType != null) {
                        recordStruct.addField(field2.name(), fieldType);
                        continue;
                    }
                    throw new IllegalStateException("Should never get a null type as fieldType.");
                }
                return recordStruct;
            }
            case MAP: {
                return TypeDescription.createMap((TypeDescription)TypeDescription.createString(), (TypeDescription)AvroOrcSchemaConverter.getOrcSchema(avroSchema.getValueType()));
            }
            case UNION: {
                List<Schema> nonNullMembers = AvroOrcSchemaConverter.getNonNullMembersOfUnion(avroSchema);
                if (AvroOrcSchemaConverter.isNullableUnion(avroSchema, nonNullMembers)) {
                    return AvroOrcSchemaConverter.getOrcSchema(nonNullMembers.get(0));
                }
                TypeDescription union = TypeDescription.createUnion();
                for (Schema childSchema : nonNullMembers) {
                    union.addUnionChild(AvroOrcSchemaConverter.getOrcSchema(childSchema));
                }
                return union;
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case ENUM: {
                return TypeDescription.createString();
            }
            case FIXED: {
                return TypeDescription.createBinary();
            }
        }
        throw new IllegalStateException(String.format("Unrecognized Avro type: %s", type.getName()));
    }

    private static boolean isNullableUnion(Schema unionSchema, List<Schema> nonNullMembers) {
        return unionSchema.getTypes().size() == 2 && nonNullMembers.size() == 1;
    }

    public static List<Schema> getNonNullMembersOfUnion(Schema unionSchema) {
        return unionSchema.getTypes().stream().filter(schema -> !Schema.Type.NULL.equals((Object)schema.getType())).collect(Collectors.toList());
    }

    public static Schema sanitizeNullableSchema(Schema avroSchema) {
        if (avroSchema.getType() != Schema.Type.UNION) {
            return avroSchema;
        }
        List<Schema> members = AvroOrcSchemaConverter.getNonNullMembersOfUnion(avroSchema);
        if (AvroOrcSchemaConverter.isNullableUnion(avroSchema, members)) {
            return members.get(0);
        }
        return Schema.createUnion(members);
    }
}

