/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.iceberg.Utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NullNode;

public final class TypeInfoToSchemaParser {
    private static final String DECIMAL_TYPE_NAME = "decimal";
    private static final String CHAR_TYPE_NAME = "char";
    private static final String VARCHAR_TYPE_NAME = "varchar";
    private static final String DATE_TYPE_NAME = "date";
    private static final String TIMESTAMP_TYPE_NAME = "timestamp-millis";
    private static final String AVRO_PROP_LOGICAL_TYPE = "logicalType";
    private static final String AVRO_PROP_PRECISION = "precision";
    private static final String AVRO_PROP_SCALE = "scale";
    private static final String AVRO_PROP_MAX_LENGTH = "maxLength";
    private static final String AVRO_STRING_TYPE_NAME = "string";
    private static final String AVRO_INT_TYPE_NAME = "int";
    private static final String AVRO_LONG_TYPE_NAME = "long";
    private static final String AVRO_SHORT_TYPE_NAME = "short";
    private static final String AVRO_BYTE_TYPE_NAME = "byte";
    private int _recordCounter = 0;
    private final String _namespace;
    private final boolean _mkFieldsOptional;
    private final Map<String, String> _downToUpCaseMap;

    public TypeInfoToSchemaParser(String namespace, boolean mkFieldsOptional, Map<String, String> downToUpCaseMap) {
        this._namespace = namespace;
        this._mkFieldsOptional = mkFieldsOptional;
        this._downToUpCaseMap = downToUpCaseMap;
    }

    public Schema parseSchemaFromFieldsTypeInfo(String recordNamespace, String recordName, List<String> fieldNames, List<TypeInfo> fieldTypeInfos) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            TypeInfo fieldTypeInfo = fieldTypeInfos.get(i);
            String fieldName = fieldNames.get(i);
            fieldName = TypeInfoToSchemaParser.removePrefix(fieldName);
            fieldName = this._downToUpCaseMap.getOrDefault(fieldName, fieldName);
            Schema schema = this.parseSchemaFromTypeInfo(fieldTypeInfo, recordNamespace + "." + recordName.toLowerCase(), StringUtils.capitalize((String)fieldName));
            Schema.Field f = new Schema.Field(fieldName, schema, (String)null, (JsonNode)(this._mkFieldsOptional ? NullNode.instance : null));
            fields.add(f);
        }
        Schema recordSchema = Schema.createRecord((String)recordName, (String)null, (String)(this._namespace + recordNamespace), (boolean)false);
        recordSchema.setFields(fields);
        return recordSchema;
    }

    Schema parseSchemaFromTypeInfo(TypeInfo typeInfo, String recordNamespace, String recordName) {
        Schema schema;
        ObjectInspector.Category c = typeInfo.getCategory();
        switch (c) {
            case STRUCT: {
                schema = this.parseSchemaFromStruct((StructTypeInfo)typeInfo, recordNamespace, recordName);
                break;
            }
            case LIST: {
                schema = this.parseSchemaFromList((ListTypeInfo)typeInfo, recordNamespace, recordName);
                break;
            }
            case MAP: {
                schema = this.parseSchemaFromMap((MapTypeInfo)typeInfo, recordNamespace, recordName);
                break;
            }
            case PRIMITIVE: {
                schema = this.parseSchemaFromPrimitive((PrimitiveTypeInfo)typeInfo);
                break;
            }
            case UNION: {
                schema = this.parseSchemaFromUnion((UnionTypeInfo)typeInfo, recordNamespace, recordName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Conversion from " + c + " not supported");
            }
        }
        return this._mkFieldsOptional ? TypeInfoToSchemaParser.wrapInNullableUnion(schema) : schema;
    }

    private Schema parseSchemaFromUnion(UnionTypeInfo typeInfo, String recordNamespace, String recordName) {
        List typeInfos = typeInfo.getAllUnionObjectTypeInfos();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (TypeInfo ti : typeInfos) {
            Schema candidate;
            if (ti instanceof StructTypeInfo) {
                StructTypeInfo sti = (StructTypeInfo)ti;
                String newRecordName = recordName + this._recordCounter;
                ++this._recordCounter;
                candidate = this.parseSchemaFromStruct(sti, recordNamespace, newRecordName);
            } else {
                candidate = this.parseSchemaFromTypeInfo(ti, recordNamespace, recordName);
            }
            schemas.add(TypeInfoToSchemaParser.isNullableType(candidate) ? TypeInfoToSchemaParser.getOtherTypeFromNullableType(candidate) : candidate);
        }
        return Schema.createUnion(schemas);
    }

    private Schema parseSchemaFromStruct(StructTypeInfo typeInfo, String recordNamespace, String recordName) {
        Schema recordSchema = this.parseSchemaFromFieldsTypeInfo(recordNamespace, recordName, typeInfo.getAllStructFieldNames(), typeInfo.getAllStructFieldTypeInfos());
        return recordSchema;
    }

    private Schema parseSchemaFromList(ListTypeInfo typeInfo, String recordNamespace, String recordName) {
        Schema listSchema = this.parseSchemaFromTypeInfo(typeInfo.getListElementTypeInfo(), recordNamespace, recordName);
        return Schema.createArray((Schema)listSchema);
    }

    private Schema parseSchemaFromMap(MapTypeInfo typeInfo, String recordNamespace, String recordName) {
        TypeInfo keyTypeInfo = typeInfo.getMapKeyTypeInfo();
        PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveTypeInfo)keyTypeInfo).getPrimitiveCategory();
        if (pc != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UnsupportedOperationException("Key of Map can only be a String");
        }
        TypeInfo valueTypeInfo = typeInfo.getMapValueTypeInfo();
        Schema valueSchema = this.parseSchemaFromTypeInfo(valueTypeInfo, recordNamespace, recordName);
        return Schema.createMap((Schema)valueSchema);
    }

    private Schema parseSchemaFromPrimitive(PrimitiveTypeInfo primitiveTypeInfo) {
        Schema schema;
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case LONG: {
                schema = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case DATE: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                schema.addProp(AVRO_PROP_LOGICAL_TYPE, DATE_TYPE_NAME);
                break;
            }
            case TIMESTAMP: {
                schema = Schema.create((Schema.Type)Schema.Type.LONG);
                schema.addProp(AVRO_PROP_LOGICAL_TYPE, TIMESTAMP_TYPE_NAME);
                break;
            }
            case BINARY: {
                schema = Schema.create((Schema.Type)Schema.Type.BYTES);
                break;
            }
            case BOOLEAN: {
                schema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case DOUBLE: {
                schema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo dti = (DecimalTypeInfo)primitiveTypeInfo;
                JsonNodeFactory factory = JsonNodeFactory.instance;
                schema = Schema.create((Schema.Type)Schema.Type.BYTES);
                schema.addProp(AVRO_PROP_LOGICAL_TYPE, DECIMAL_TYPE_NAME);
                schema.addProp(AVRO_PROP_PRECISION, (JsonNode)factory.numberNode(dti.getPrecision()));
                schema.addProp(AVRO_PROP_SCALE, (JsonNode)factory.numberNode(dti.getScale()));
                break;
            }
            case FLOAT: {
                schema = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case BYTE: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                schema.addProp(AVRO_PROP_LOGICAL_TYPE, AVRO_BYTE_TYPE_NAME);
                break;
            }
            case SHORT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                schema.addProp(AVRO_PROP_LOGICAL_TYPE, AVRO_SHORT_TYPE_NAME);
                break;
            }
            case INT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case CHAR: 
            case STRING: 
            case VARCHAR: {
                schema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case VOID: {
                schema = Schema.create((Schema.Type)Schema.Type.NULL);
                break;
            }
            default: {
                throw new UnsupportedOperationException(primitiveTypeInfo + " is not supported.");
            }
        }
        return schema;
    }

    private static Schema wrapInNullableUnion(Schema schema) {
        Schema wrappedSchema = schema;
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case UNION: {
                ArrayList unionSchemas = Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL)});
                unionSchemas.addAll(schema.getTypes());
                wrappedSchema = Schema.createUnion((List)unionSchemas);
                break;
            }
            default: {
                wrappedSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
            }
        }
        return wrappedSchema;
    }

    private static String removePrefix(String name) {
        int idx = name.lastIndexOf(46);
        return idx > 0 ? name.substring(idx + 1) : name;
    }

    private static boolean isNullableType(Schema schema) {
        Schema itemSchema;
        if (!schema.getType().equals((Object)Schema.Type.UNION)) {
            return false;
        }
        List itemSchemas = schema.getTypes();
        if (itemSchemas.size() < 2) {
            return false;
        }
        Iterator var2 = itemSchemas.iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!Schema.Type.NULL.equals((Object)(itemSchema = (Schema)var2.next()).getType()));
        return true;
    }

    private static Schema getOtherTypeFromNullableType(Schema unionSchema) {
        List types = unionSchema.getTypes();
        if (types.size() == 2) {
            if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                return (Schema)types.get(1);
            }
            return ((Schema)types.get(1)).getType() == Schema.Type.NULL ? (Schema)types.get(0) : unionSchema;
        }
        ArrayList<Schema> itemSchemas = new ArrayList<Schema>();
        for (Schema itemSchema : types) {
            if (Schema.Type.NULL.equals((Object)itemSchema.getType())) continue;
            itemSchemas.add(itemSchema);
        }
        if (itemSchemas.size() > 1) {
            return Schema.createUnion(itemSchemas);
        }
        return (Schema)itemSchemas.get(0);
    }
}

