/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.writer;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.Pair;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterConfigurationKeys;
import org.apache.gobblin.elasticsearch.writer.ExceptionLogger;
import org.apache.gobblin.elasticsearch.writer.MalformedDocPolicy;
import org.apache.gobblin.writer.GenericWriteResponse;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureCallbackHolder {
    private static final Logger log = LoggerFactory.getLogger(FutureCallbackHolder.class);
    private final ActionListener<BulkResponse> actionListener;
    private final BlockingQueue<Pair<WriteResponse, Throwable>> writeResponseQueue = new ArrayBlockingQueue<Pair<WriteResponse, Throwable>>(1);
    private final Future<WriteResponse> future;
    private final AtomicBoolean done = new AtomicBoolean(false);

    public FutureCallbackHolder(final @Nullable WriteCallback callback, final ExceptionLogger exceptionLogger, final MalformedDocPolicy malformedDocPolicy) {
        this.future = new Future<WriteResponse>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return FutureCallbackHolder.this.done.get();
            }

            @Override
            public WriteResponse get() throws InterruptedException, ExecutionException {
                Pair writeResponseThrowablePair = (Pair)FutureCallbackHolder.this.writeResponseQueue.take();
                return FutureCallbackHolder.this.getWriteResponseorThrow((Pair<WriteResponse, Throwable>)writeResponseThrowablePair);
            }

            @Override
            public WriteResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Pair writeResponseThrowablePair = (Pair)FutureCallbackHolder.this.writeResponseQueue.poll(timeout, unit);
                if (writeResponseThrowablePair == null) {
                    throw new TimeoutException("Timeout exceeded while waiting for future to be done");
                }
                return FutureCallbackHolder.this.getWriteResponseorThrow((Pair<WriteResponse, Throwable>)writeResponseThrowablePair);
            }
        };
        this.actionListener = new ActionListener<BulkResponse>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onResponse(BulkResponse bulkItemResponses) {
                if (bulkItemResponses.hasFailures()) {
                    boolean logicalErrors = false;
                    boolean serverErrors = false;
                    for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                        if (!bulkItemResponse.isFailed()) continue;
                        if (this.isLogicalError(bulkItemResponse)) {
                            switch (malformedDocPolicy) {
                                case IGNORE: {
                                    log.debug("Document id {} was malformed with error {}", (Object)bulkItemResponse.getId(), (Object)bulkItemResponse.getFailureMessage());
                                    break;
                                }
                                case WARN: {
                                    log.warn("Document id {} was malformed with error {}", (Object)bulkItemResponse.getId(), (Object)bulkItemResponse.getFailureMessage());
                                    break;
                                }
                            }
                            logicalErrors = true;
                            continue;
                        }
                        serverErrors = true;
                    }
                    if (serverErrors) {
                        this.onFailure(new RuntimeException("Partial failures in the batch: " + bulkItemResponses.buildFailureMessage()));
                        return;
                    } else {
                        if (!logicalErrors) return;
                        switch (malformedDocPolicy) {
                            case FAIL: {
                                this.onFailure(new RuntimeException("Partial non-recoverable failures in the batch. To ignore these, set " + ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_MALFORMED_DOC_POLICY + " to " + MalformedDocPolicy.IGNORE.name()));
                                return;
                            }
                            default: {
                                GenericWriteResponse writeResponse = new GenericWriteResponse((Object)bulkItemResponses);
                                FutureCallbackHolder.this.writeResponseQueue.add(new Pair((Object)writeResponse, null));
                                if (callback == null) return;
                                callback.onSuccess((Object)writeResponse);
                            }
                        }
                    }
                    return;
                } else {
                    GenericWriteResponse writeResponse = new GenericWriteResponse((Object)bulkItemResponses);
                    FutureCallbackHolder.this.writeResponseQueue.add(new Pair((Object)writeResponse, null));
                    if (callback == null) return;
                    callback.onSuccess((Object)writeResponse);
                }
            }

            private boolean isLogicalError(BulkItemResponse bulkItemResponse) {
                String failureMessage = bulkItemResponse.getFailureMessage();
                return failureMessage.contains("IllegalArgumentException") || failureMessage.contains("illegal_argument_exception") || failureMessage.contains("MapperParsingException") || failureMessage.contains("mapper_parsing_exception");
            }

            public void onFailure(Exception exception) {
                FutureCallbackHolder.this.writeResponseQueue.add(new Pair(null, (Object)exception));
                if (exceptionLogger != null) {
                    exceptionLogger.log(exception);
                }
                if (callback != null) {
                    callback.onFailure((Throwable)exception);
                }
            }
        };
    }

    private WriteResponse getWriteResponseorThrow(Pair<WriteResponse, Throwable> writeResponseThrowablePair) throws ExecutionException {
        try {
            if (writeResponseThrowablePair.getFirst() != null) {
                WriteResponse writeResponse = (WriteResponse)writeResponseThrowablePair.getFirst();
                return writeResponse;
            }
            if (writeResponseThrowablePair.getSecond() != null) {
                throw new ExecutionException((Throwable)writeResponseThrowablePair.getSecond());
            }
            throw new ExecutionException(new RuntimeException("Could not find non-null WriteResponse pair"));
        }
        finally {
            this.done.set(true);
        }
    }

    public ActionListener<BulkResponse> getActionListener() {
        return this.actionListener;
    }

    public Future<WriteResponse> getFuture() {
        return this.future;
    }
}

