/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.writer;

import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchRestWriter;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchTransportClientWriter;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterBase;
import org.apache.gobblin.elasticsearch.writer.ElasticsearchWriterConfigurationKeys;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.AsyncWriterManager;
import org.apache.gobblin.writer.BatchAccumulator;
import org.apache.gobblin.writer.BatchAsyncDataWriter;
import org.apache.gobblin.writer.BufferedAsyncDataWriter;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.gobblin.writer.SequentialBasedBatchAccumulator;

public class ElasticsearchDataWriterBuilder
extends DataWriterBuilder {
    public DataWriter build() throws IOException {
        ElasticsearchWriterBase asyncDataWriter;
        State state = this.destination.getProperties();
        Properties taskProps = state.getProperties();
        Config config = ConfigUtils.propertiesToConfig((Properties)taskProps);
        SequentialBasedBatchAccumulator batchAccumulator = new SequentialBasedBatchAccumulator(taskProps);
        switch (ElasticsearchWriterConfigurationKeys.ClientType.valueOf(ConfigUtils.getString((Config)config, (String)ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_CLIENT_TYPE, (String)"REST").toUpperCase())) {
            case REST: {
                asyncDataWriter = new ElasticsearchRestWriter(config);
                break;
            }
            case TRANSPORT: {
                asyncDataWriter = new ElasticsearchTransportClientWriter(config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Need to specify which " + ElasticsearchWriterConfigurationKeys.ELASTICSEARCH_WRITER_CLIENT_TYPE + " client to use (rest/transport)");
            }
        }
        BufferedAsyncDataWriter bufferedAsyncDataWriter = new BufferedAsyncDataWriter((BatchAccumulator)batchAccumulator, (BatchAsyncDataWriter)asyncDataWriter);
        double failureAllowance = ConfigUtils.getDouble((Config)config, (String)ElasticsearchWriterConfigurationKeys.FAILURE_ALLOWANCE_PCT_CONFIG, (double)0.0) / 100.0;
        boolean retriesEnabled = ConfigUtils.getBoolean((Config)config, (String)ElasticsearchWriterConfigurationKeys.RETRIES_ENABLED, (boolean)true);
        int maxRetries = ConfigUtils.getInt((Config)config, (String)ElasticsearchWriterConfigurationKeys.MAX_RETRIES, (Integer)5);
        return AsyncWriterManager.builder().failureAllowanceRatio(failureAllowance).retriesEnabled(retriesEnabled).numRetries(maxRetries).config(config).asyncDataWriter((AsyncDataWriter)bufferedAsyncDataWriter).build();
    }
}

