/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.typemapping;

import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.elasticsearch.typemapping.AvroGenericRecordSerializer;
import org.apache.gobblin.elasticsearch.typemapping.FieldMappingException;
import org.apache.gobblin.elasticsearch.typemapping.JsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroGenericRecordTypeMapper
implements TypeMapper<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AvroGenericRecordTypeMapper.class);
    private final JsonSerializer<GenericRecord> serializer;
    private final Closer closer = Closer.create();

    public AvroGenericRecordTypeMapper() {
        this.serializer = (JsonSerializer)this.closer.register((Closeable)new AvroGenericRecordSerializer());
    }

    @Override
    public void configure(Config config) {
        this.serializer.configure(config);
        log.info("AvroGenericRecordTypeMapper successfully configured");
    }

    @Override
    public JsonSerializer<GenericRecord> getSerializer() {
        return this.serializer;
    }

    @Override
    public String getValue(String fieldName, GenericRecord record) throws FieldMappingException {
        try {
            Object idValue = record.get(fieldName);
            return idValue.toString();
        }
        catch (Exception e) {
            throw new FieldMappingException("Could not find field " + fieldName, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

