/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.elasticsearch.typemapping;

import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.gobblin.elasticsearch.typemapping.JsonSerializer;
import org.apache.gobblin.elasticsearch.typemapping.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroGenericRecordSerializer
implements JsonSerializer<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AvroGenericRecordSerializer.class);
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final DataOutputStream out;
    private final GenericDatumWriter<GenericRecord> writer;
    private final Closer closer = Closer.create();

    public AvroGenericRecordSerializer() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.out = (DataOutputStream)this.closer.register((Closeable)new DataOutputStream((OutputStream)this.byteArrayOutputStream));
        this.writer = new GenericDatumWriter();
    }

    @Override
    public void configure(Config config) {
    }

    @Override
    public synchronized byte[] serializeToJson(GenericRecord serializable) throws SerializationException {
        try {
            String serialized = serializable.toString();
            return serialized.getBytes(Charset.forName("UTF-8"));
        }
        catch (Exception exception) {
            throw new SerializationException("Could not serializeToJson Avro record", exception);
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

