/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.schema_check;

import org.apache.avro.Schema;
import org.apache.gobblin.configuration.WorkUnitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AvroSchemaCheckStrategy {
    public boolean compare(Schema var1, Schema var2);

    public static class AvroSchemaCheckStrategyFactory {
        private static final Logger log = LoggerFactory.getLogger(AvroSchemaCheckStrategyFactory.class);

        public static AvroSchemaCheckStrategy create(WorkUnitState state) {
            try {
                return (AvroSchemaCheckStrategy)Class.forName(state.getProp("avro.schema.check.strategy", "org.apache.gobblin.util.schema_check.AvroSchemaCheckDefaultStrategy")).newInstance();
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return null;
            }
        }
    }
}

