/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.commit;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.data.management.copy.OwnerAndPermission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPermissionCommitStep
implements CommitStep {
    private static final Logger log = LoggerFactory.getLogger(SetPermissionCommitStep.class);
    Map<String, OwnerAndPermission> pathAndPermissions;
    private final URI fsUri;
    public final boolean stopOnError;
    public static final String STOP_ON_ERROR_KEY = "stop.on.error";
    public static final String DEFAULT_STOP_ON_ERROR = "false";
    private boolean isCompleted = false;

    public SetPermissionCommitStep(FileSystem targetFs, Map<String, OwnerAndPermission> pathAndPermissions, Properties props) {
        this.pathAndPermissions = pathAndPermissions;
        this.fsUri = targetFs.getUri();
        this.stopOnError = Boolean.parseBoolean(props.getProperty(STOP_ON_ERROR_KEY, DEFAULT_STOP_ON_ERROR));
    }

    public boolean isCompleted() throws IOException {
        return this.isCompleted;
    }

    public void execute() throws IOException {
        FileSystem fs = FileSystem.get((URI)this.fsUri, (Configuration)new Configuration());
        for (Map.Entry<String, OwnerAndPermission> entry : this.pathAndPermissions.entrySet()) {
            Path path = new Path(entry.getKey());
            try {
                log.info("Setting permission {} on path {}", (Object)entry.getValue().getFsPermission(), (Object)path);
                fs.setPermission(path, entry.getValue().getFsPermission());
            }
            catch (AccessControlException e) {
                log.warn("Error while setting permission on " + path, (Throwable)e);
                if (!this.stopOnError) continue;
                log.info("Skip setting rest of the permissions because stopOnError is true.");
                break;
            }
        }
        this.isCompleted = true;
    }
}

