/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.embedded;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.copy.CopySource;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.cli.CliObjectOption;
import org.apache.gobblin.runtime.cli.NotOnCli;
import org.apache.gobblin.runtime.cli.PublicMethodsGobblinCliFactory;
import org.apache.gobblin.runtime.embedded.EmbeddedGobblin;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class EmbeddedGobblinDistcp
extends EmbeddedGobblin {
    public EmbeddedGobblinDistcp(Path from, Path to) throws JobTemplate.TemplateException, IOException {
        this("templates/distcp.template", from, to);
    }

    public EmbeddedGobblinDistcp(String templateLoc, Path from, Path to) throws JobTemplate.TemplateException, IOException {
        super("Distcp");
        try {
            this.setTemplate((JobTemplate)ResourceBasedJobTemplate.forResourcePath((String)templateLoc));
        }
        catch (URISyntaxException | SpecNotFoundException exc) {
            throw new RuntimeException("Could not instantiate an " + EmbeddedGobblinDistcp.class.getName(), exc);
        }
        this.setConfiguration("from", from.toString());
        this.setConfiguration("to", to.toString());
        this.setConfiguration("source.filebased.fs.uri", from.getFileSystem(new Configuration()).getUri().toString());
        this.setConfiguration("writer.fs.uri", to.getFileSystem(new Configuration()).getUri().toString());
        this.distributeJarByClassWithPriority(CopySource.class, 0);
    }

    @CliObjectOption(description="Specifies files should be updated if they're different in the source.")
    public EmbeddedGobblinDistcp update() {
        this.setConfiguration("gobblin.copy.recursive.update", Boolean.toString(true));
        return this;
    }

    @CliObjectOption(description="Delete files in target that don't exist on source.")
    public EmbeddedGobblinDistcp delete() {
        this.setConfiguration("gobblin.copy.recursive.delete", Boolean.toString(true));
        return this;
    }

    @CliObjectOption(description="If deleting files on target, also delete newly empty parent directories.")
    public EmbeddedGobblinDistcp deleteEmptyParentDirectories() {
        this.setConfiguration("gobblin.copy.recursive.deleteEmptyDirectories", Boolean.toString(true));
        return this;
    }

    public EmbeddedGobblinDistcp simulate() {
        this.setConfiguration("gobblin.copy.simulate", Boolean.toString(true));
        return this;
    }

    @NotOnCli
    public EmbeddedGobblin setTemplate(String templateURI) throws URISyntaxException, SpecNotFoundException, JobTemplate.TemplateException {
        return super.setTemplate(templateURI);
    }

    @Alias(value="distcp", description="Distributed copy between Hadoop compatibly file systems.")
    public static class CliFactory
    extends PublicMethodsGobblinCliFactory {
        public CliFactory() {
            super(EmbeddedGobblinDistcp.class);
        }

        public EmbeddedGobblin constructEmbeddedGobblin(CommandLine cli) throws JobTemplate.TemplateException, IOException {
            String[] leftoverArgs = cli.getArgs();
            if (leftoverArgs.length != 2) {
                throw new RuntimeException("Unexpected number of arguments.");
            }
            Path from = new Path(leftoverArgs[0]);
            Path to = new Path(leftoverArgs[1]);
            return new EmbeddedGobblinDistcp(from, to);
        }

        public String getUsageString() {
            return "[OPTIONS] <source> <target>";
        }
    }
}

