/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.joda.time.DateTime;

public class ModDateTimeDatasetVersionFinder
implements VersionFinder<TimestampedDatasetVersion> {
    private final FileSystem fs;

    public ModDateTimeDatasetVersionFinder(FileSystem fs, Properties props) {
        this(fs, ConfigFactory.parseProperties((Properties)props));
    }

    public ModDateTimeDatasetVersionFinder(FileSystem fs, Config conf) {
        this.fs = fs;
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Collection<TimestampedDatasetVersion> findDatasetVersions(Dataset dataset) throws IOException {
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        FileStatus status = this.fs.getFileStatus(fsDataset.datasetRoot());
        return Lists.newArrayList((Object[])new TimestampedDatasetVersion[]{new TimestampedDatasetVersion(new DateTime(status.getModificationTime()), fsDataset.datasetRoot())});
    }
}

