/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.data.management.trash.ProxiedTrash;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.gobblin.util.ProxiedFileSystemCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ImmediateDeletionTrash
extends ProxiedTrash {
    public ImmediateDeletionTrash(FileSystem fs, Properties props, String user) throws IOException {
        super(fs, props, user);
    }

    @Override
    protected Trash createNewTrashForUser(FileSystem fs, Properties properties, String user) throws IOException {
        return new ImmediateDeletionTrash(ProxiedFileSystemCache.fromProperties().userNameToProxyAs(user).properties(properties).referenceFS(fs).build(), properties, user);
    }

    @Override
    public boolean moveToTrash(Path path) throws IOException {
        return this.fs.delete(path, true);
    }

    @Override
    protected void ensureTrashLocationExists(FileSystem fs, Path trashLocation) throws IOException {
    }
}

