/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.action;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.action.RetentionAction;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.data.management.version.FileStatusAware;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlAction
extends RetentionAction {
    private static final Logger log = LoggerFactory.getLogger(AccessControlAction.class);
    private static final String MODE_KEY = "mode";
    private static final String OWNER_KEY = "owner";
    private static final String GROUP_KEY = "group";
    private final Optional<FsPermission> permission;
    private final Optional<String> owner;
    private final Optional<String> group;
    @VisibleForTesting
    private final VersionSelectionPolicy<DatasetVersion> selectionPolicy;

    @VisibleForTesting
    AccessControlAction(Config actionConfig, FileSystem fs, Config jobConfig) {
        super(actionConfig, fs, jobConfig);
        this.permission = actionConfig.hasPath(MODE_KEY) ? Optional.of((Object)new FsPermission(actionConfig.getString(MODE_KEY))) : Optional.absent();
        this.owner = Optional.fromNullable((Object)ConfigUtils.getString((Config)actionConfig, (String)OWNER_KEY, null));
        this.group = Optional.fromNullable((Object)ConfigUtils.getString((Config)actionConfig, (String)GROUP_KEY, null));
        this.selectionPolicy = this.createSelectionPolicy(actionConfig, jobConfig);
    }

    @Override
    public void execute(List<DatasetVersion> allVersions) throws IOException {
        for (DatasetVersion datasetVersion : this.selectionPolicy.listSelectedVersions(allVersions)) {
            this.executeOnVersion(datasetVersion);
        }
    }

    private void executeOnVersion(DatasetVersion datasetVersion) throws IOException {
        block4: {
            if (!(datasetVersion instanceof FileSystemDatasetVersion)) break block4;
            FileSystemDatasetVersion fsDatasetVersion = (FileSystemDatasetVersion)datasetVersion;
            if (datasetVersion instanceof FileStatusAware) {
                for (FileStatus fileStatus : ((FileStatusAware)((Object)datasetVersion)).getFileStatuses()) {
                    if (!this.needsPermissionsUpdate(fileStatus) && !this.needsOwnerUpdate(fileStatus) && !this.needsGroupUpdate(fileStatus)) continue;
                    this.updatePermissionsAndOwner(fileStatus.getPath());
                }
            } else {
                for (Path path : fsDatasetVersion.getPaths()) {
                    this.updatePermissionsAndOwner(path);
                }
            }
        }
    }

    private boolean needsPermissionsUpdate(FileStatus fileStatus) {
        return this.permission.isPresent() && !((FsPermission)this.permission.get()).equals((Object)fileStatus.getPermission());
    }

    private boolean needsOwnerUpdate(FileStatus fileStatus) {
        return this.owner.isPresent() && !StringUtils.equals((CharSequence)((CharSequence)this.owner.get()), (CharSequence)fileStatus.getOwner());
    }

    private boolean needsGroupUpdate(FileStatus fileStatus) {
        return this.group.isPresent() && !StringUtils.equals((CharSequence)((CharSequence)this.group.get()), (CharSequence)fileStatus.getGroup());
    }

    private void updatePermissionsAndOwner(Path path) throws IOException {
        boolean atLeastOneOperationFailed = false;
        if (this.fs.exists(path)) {
            try {
                if (this.permission.isPresent()) {
                    if (!this.isSimulateMode) {
                        this.fs.setPermission(path, (FsPermission)this.permission.get());
                        log.debug("Set permissions for {} to {}", (Object)path, this.permission.get());
                    } else {
                        log.info("Simulating set permissions for {} to {}", (Object)path, this.permission.get());
                    }
                }
            }
            catch (IOException e) {
                log.error(String.format("Setting permissions failed on %s", path), (Throwable)e);
                atLeastOneOperationFailed = true;
            }
            if (this.owner.isPresent() || this.group.isPresent()) {
                if (!this.isSimulateMode) {
                    this.fs.setOwner(path, (String)this.owner.orNull(), (String)this.group.orNull());
                    log.debug("Set owner and group for {} to {}:{}", new Object[]{path, this.owner.orNull(), this.group.orNull()});
                } else {
                    log.info("Simulating set owner and group for {} to {}:{}", new Object[]{path, this.owner.orNull(), this.group.orNull()});
                }
            }
            if (atLeastOneOperationFailed) {
                throw new RuntimeException(String.format("At least one failure happened while processing %s. Look for previous logs for failures", path));
            }
        }
    }

    public VersionSelectionPolicy<DatasetVersion> getSelectionPolicy() {
        return this.selectionPolicy;
    }
}

