/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.dataset;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.data.management.dataset.DefaultFileSystemGlobFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.util.PropertiesUtils;
import org.apache.gobblin.util.function.CheckedExceptionPredicate;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DatasetsFinderFilteringDecorator<T extends Dataset>
implements DatasetsFinder<T> {
    private static final String PREFIX = "filtering.datasets.finder.";
    public static final String DATASET_CLASS = "filtering.datasets.finder.class";
    public static final String ALLOWED = "filtering.datasets.finder.allowed.predicates";
    public static final String DENIED = "filtering.datasets.finder.denied.predicates";
    protected DatasetsFinder<T> datasetFinder;
    protected List<CheckedExceptionPredicate<T, IOException>> allowDatasetPredicates;
    protected List<CheckedExceptionPredicate<T, IOException>> denyDatasetPredicates;

    public DatasetsFinderFilteringDecorator(FileSystem fs, Properties properties) throws IOException {
        this.datasetFinder = DatasetUtils.instantiateDatasetFinder(DATASET_CLASS, properties, fs, DefaultFileSystemGlobFinder.class.getName(), new Object[0]);
        this.allowDatasetPredicates = this.instantiatePredicates(ALLOWED, properties);
        this.denyDatasetPredicates = this.instantiatePredicates(DENIED, properties);
    }

    @VisibleForTesting
    DatasetsFinderFilteringDecorator(DatasetsFinder<T> datasetsFinder, List<CheckedExceptionPredicate<T, IOException>> allowDatasetPredicates, List<CheckedExceptionPredicate<T, IOException>> denyDatasetPredicates) {
        this.datasetFinder = datasetsFinder;
        this.allowDatasetPredicates = allowDatasetPredicates;
        this.denyDatasetPredicates = denyDatasetPredicates;
    }

    public List<T> findDatasets() throws IOException {
        List datasets = this.datasetFinder.findDatasets();
        List allowedDatasets = Collections.emptyList();
        try {
            allowedDatasets = datasets.parallelStream().filter(dataset -> this.allowDatasetPredicates.stream().map(CheckedExceptionPredicate::wrapToTunneled).allMatch(p -> p.test(dataset))).filter(dataset -> this.denyDatasetPredicates.stream().map(CheckedExceptionPredicate::wrapToTunneled).noneMatch(predicate -> predicate.test(dataset))).collect(Collectors.toList());
        }
        catch (CheckedExceptionPredicate.WrappedIOException wrappedIOException) {
            wrappedIOException.rethrowWrapped();
        }
        return allowedDatasets;
    }

    public Path commonDatasetRoot() {
        return this.datasetFinder.commonDatasetRoot();
    }

    private List<CheckedExceptionPredicate<T, IOException>> instantiatePredicates(String key, Properties props) throws IOException {
        ArrayList<CheckedExceptionPredicate<T, IOException>> predicates = new ArrayList<CheckedExceptionPredicate<T, IOException>>();
        try {
            for (String className : PropertiesUtils.getPropAsList((Properties)props, (String)key)) {
                predicates.add((CheckedExceptionPredicate)ConstructorUtils.invokeConstructor(Class.forName(className), (Object[])new Object[]{props}));
            }
            return predicates;
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }
}

