/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.data.management.copy.replication.WatermarkMetadataUtil;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class WatermarkMetadataGenerationCommitStep
implements CommitStep {
    private final String fsUriString;
    private final Path targetDirPath;
    private final Watermark watermark;
    private boolean completed = false;

    public WatermarkMetadataGenerationCommitStep(String fsString, Path targetDirPath, Watermark wm) {
        this.fsUriString = fsString;
        this.targetDirPath = targetDirPath;
        this.watermark = wm;
    }

    public boolean isCompleted() throws IOException {
        return this.completed;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("metafile", (Object)new Path(this.targetDirPath, "_metadata")).add("file system uri", (Object)this.fsUriString).add("watermark class", (Object)this.watermark.getClass().getCanonicalName()).add("watermark json", (Object)this.watermark.toJson().toString()).toString();
    }

    public void execute() throws IOException {
        URI fsURI;
        try {
            fsURI = new URI(this.fsUriString);
        }
        catch (URISyntaxException e) {
            throw new IOException("can not build URI " + this.fsUriString, e);
        }
        FileSystem fs = FileSystem.get((URI)fsURI, (Configuration)new Configuration());
        Path filenamePath = new Path(this.targetDirPath, "_metadata");
        if (fs.exists(filenamePath)) {
            fs.delete(filenamePath, false);
        }
        FSDataOutputStream fout = fs.create(filenamePath);
        fout.write(WatermarkMetadataUtil.serialize(this.watermark).getBytes(Charsets.UTF_8));
        fout.close();
        this.completed = true;
    }
}

