/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReplicationMetaData {
    private final Optional<Map<String, String>> values;

    public static ReplicationMetaData buildMetaData(Config config) {
        if (!config.hasPath("metadata")) {
            return new ReplicationMetaData((Optional<Map<String, String>>)Optional.absent());
        }
        Config metaDataConfig = config.getConfig("metadata");
        HashMap metaDataValues = new HashMap();
        Set meataDataEntry = metaDataConfig.entrySet();
        for (Map.Entry entry : meataDataEntry) {
            metaDataValues.put(entry.getKey(), metaDataConfig.getString((String)entry.getKey()));
        }
        ReplicationMetaData metaData = new ReplicationMetaData((Optional<Map<String, String>>)Optional.of(metaDataValues));
        return metaData;
    }

    public String toString() {
        Joiner.MapJoiner mapJoiner = Joiner.on((char)',').withKeyValueSeparator("=");
        return Objects.toStringHelper(this.getClass()).add("metadata", (Object)mapJoiner.join((Map)this.values.get())).toString();
    }

    public ReplicationMetaData(Optional<Map<String, String>> values) {
        this.values = values;
    }

    public Optional<Map<String, String>> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplicationMetaData)) {
            return false;
        }
        ReplicationMetaData other = (ReplicationMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Map<String, String>> this$values = this.getValues();
        Optional<Map<String, String>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !this$values.equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplicationMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Map<String, String>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : $values.hashCode());
        return result;
    }
}

