/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.collect.Ordering;
import com.typesafe.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPoint;
import org.apache.gobblin.data.management.copy.replication.HadoopFsEndPointDataset;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ReplicationDataValidPathPicker {
    public static final String POLICY_CLASS = "selection.policy.class";
    public static final String FINDER_CLASS = "version.finder.class";

    public static Collection<Path> getValidPaths(HadoopFsEndPoint hadoopFsEndPoint) throws IOException {
        VersionSelectionPolicy selector;
        VersionFinder finder;
        Config selectionConfig = hadoopFsEndPoint.getSelectionConfig();
        HadoopFsEndPointDataset tmpDataset = new HadoopFsEndPointDataset(hadoopFsEndPoint);
        FileSystem theFs = FileSystem.get((URI)hadoopFsEndPoint.getFsURI(), (Configuration)new Configuration());
        try {
            finder = (VersionFinder)ConstructorUtils.invokeConstructor(Class.forName(selectionConfig.getString(FINDER_CLASS)), (Object[])new Object[]{theFs, selectionConfig});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        List versions = Ordering.natural().reverse().sortedCopy(finder.findDatasetVersions((Dataset)tmpDataset));
        try {
            selector = (VersionSelectionPolicy)ConstructorUtils.invokeConstructor(Class.forName(selectionConfig.getString(POLICY_CLASS)), (Object[])new Object[]{selectionConfig});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        Collection versionsSelected = selector.listSelectedVersions(versions);
        ArrayList<Path> result = new ArrayList<Path>();
        for (FileSystemDatasetVersion t : versionsSelected) {
            result.add(t.getPaths().iterator().next());
        }
        return result;
    }
}

