/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.gobblin.data.management.copy.replication.CopyRoute;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGenerator;
import org.apache.gobblin.data.management.copy.replication.DataFlowTopology;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.data.management.copy.replication.ReplicationConfiguration;
import org.apache.gobblin.data.management.copy.replication.ReplicationCopyMode;

public class CopyRouteGeneratorBase
implements CopyRouteGenerator {
    @Override
    public Optional<CopyRoute> getPullRoute(ReplicationConfiguration rc, EndPoint copyTo) {
        return Optional.absent();
    }

    @Override
    public Optional<List<CopyRoute>> getPushRoutes(ReplicationConfiguration rc, EndPoint copyFrom) {
        if (rc.getCopyMode() == ReplicationCopyMode.PULL) {
            return Optional.absent();
        }
        DataFlowTopology topology = rc.getDataFlowToplogy();
        List<DataFlowTopology.DataFlowPath> paths = topology.getDataFlowPaths();
        for (DataFlowTopology.DataFlowPath p : paths) {
            List<CopyRoute> routes = p.getCopyRoutes();
            if (routes.isEmpty() || !routes.get(0).getCopyFrom().equals(copyFrom)) continue;
            return Optional.of(routes);
        }
        return Optional.absent();
    }
}

